#include <stdio.h>
#include <string.h>
#include "gph_opind.h"
#include "gph_str.h"
#include "gph_ansi.h"
#define RASTER
#include "gph_ansi_dr.h"

static ByTe_1 rcsid[] = "$Id: rs_poly.c,v 1.1 1999/11/21 10:07:06 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 rs_poly (ByTe_2 npts)
{
   extern struct config parm;
   extern struct memory minfo;

   struct scr_info *dv; 
   register ReaL_4 *data, *dEnd;
   register ByTe_2 Xmax, Ymax, Xmin, Ymin;
   ByTe_2 dX, dY;

  /*************************************************************/
  /* Scale points - if because of clipping there is not a      */
  /* polygon left to be filled then we're outta here.          */
  /*************************************************************/

   if ((npts = scale_pts (npts, 1)) < 4)
      return (1);

   dv  = parm.drv->dev;

   data = (ReaL_4 *) minfo.mxyz;

   dEnd = data + 2 * npts;
   Xmin = *data;
   Xmax = *data++;
   Ymin = *data;
   Ymax = *data++;

   for ( ; data < dEnd; ++data)
   {
      if (*data > Xmax)
         Xmax = *data; 
      else
         if (*data < Xmin)
            Xmin = *data; 

      ++data;

      if (*data > Ymax)
         Ymax = *data; 
      else
         if (*data < Ymin)
            Ymin = *data; 
   }

   dX = Xmax - Xmin;
   dY = Ymax - Ymin;
   if ((dX == 0) || (dY == 0) || (dX < 2 && dY < 2))
      parm.drv->_line (npts, 5);
   else
   {
      parm.drv->_line (npts, 3);
      RasterFill (Xmin, Ymin, Xmax, Ymax);
      parm.drv->_line (npts, 4);
   }

   return (1);
}
