#include "gph_str.h"
#include "gph_ansi.h"
#define   RASTER
#include "gph_ansi_dr.h"

static ByTe_1 rcsid[] = "$Id: rs_ldcm.c,v 1.1 1999/11/21 10:07:06 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 rs_ldcm (FILE *map, ByTe_2 size)
{
   extern struct config  parm;

   register struct color  *cl; 
   register ByTe_2  *s1;

   ReaL_4  fac;
   ByTe_4   pos, devpos;
   ByTe_2  *d, *c, i, dp_color[8];
   ByTe_2  red, green, blue;
   ByTe_1   noload,nocolor,ok;

   u_ByTe_1  *uc_ptr;

   /** initialize the color look up table to be all black **/

   s1 = (ByTe_2 *)parm.drv->w_cmd; 
   fac = 32767.0 / parm.drv->dev->ctl;
   for (i = 0; i < parm.drv->dev->ctl; ++i)
   {
       *s1++ = i * fac + 0.5; 
       *s1++ = 0;
       *s1++ = 0;
       *s1++ = 0;
   }

   cl = parm.drv->ctb;

   uc_ptr = (u_ByTe_1 *)cl->wcp;

   /*** initialize the locations in which color map is stored  ***/

   d = dp_color;
   *d++ = (parm.white >=0) ? parm.white*cl->c_scale : -1;
   *d++ = (parm.red >=0) ? parm.red*cl->c_scale : -1;
   *d++ = (parm.yellow >=0) ? parm.yellow*cl->c_scale : -1;
   *d++ = (parm.green >=0) ? parm.green*cl->c_scale : -1;
   *d++ = (parm.cyan >=0) ? parm.cyan*cl->c_scale : -1;
   *d++ = (parm.blue >=0) ? parm.blue*cl->c_scale : -1;
   *d++ = (parm.purple >=0) ? parm.purple*cl->c_scale : -1;
   *d = (parm.black >=0) ? parm.black*cl->c_scale : -1;

   for (i=0; i<size; ++i) 
   {
      fscanf (map,"%d %hd %hd %hd",&pos,&red,&green,&blue);
      noload = 0;
      ok = 1;
      devpos = pos * cl->c_scale + .001;

      for (c=cl->def_pos,d=dp_color; c<cl->def_pos+8; ++c,++d)
      {
         if (pos == *c)
         {
            ok = 0;
            devpos = *d;
            break;
         }
      }

      nocolor = (*(uc_ptr+devpos) == 0 || *(uc_ptr+devpos) == 255) ? 1 : 0;

      if (ok && *(uc_ptr+devpos) == 255)
         noload = 1;

      if (!noload && nocolor)
      {
         s1 = (ByTe_2 *)parm.drv->w_cmd + 1 + devpos * 4; 
         *s1++ = red;
         *s1++ = green;
         *s1++ = blue;
         *(uc_ptr+devpos) = (*(uc_ptr+devpos) == 0) ? 1 : 254;
      }
   }

   return(1);
}
