#include "gph_str.h"
#include "gph_ansi.h"
#define   RASTER
#include "gph_ansi_dr.h"

  /*************************************************************************/
  /* This function analyzes the coordinates of the line and decides which  */
  /* of the two line-drawing algorithms to use - either RasterX or RasterY */
  /* RasterX() draws the line as it increments along the x-axis and cannot */
  /* draw lines that are more vertical than horizontal. RasterY() is the   */
  /* reverse of this and can not draw lines that are more horizontal than  */
  /* vertical.                                                             */
  /*************************************************************************/

static ByTe_1 rcsid[] = "$Id: RasterX.c,v 1.1 1999/11/21 10:07:06 chris.gurgiolo.b2r Stab chrisg $";

void RasterX (ByTe_2 x1, ByTe_2 y1, ByTe_2 x2, ByTe_2 y2, u_ByTe_1 color,
              ByTe_1 plane)
{
    extern struct config parm;
    extern struct memory minfo;
    struct scr_info *dv;
    register u_ByTe_1 *ras;
    register ByTe_4 X, Y, Xend, Yinc;
    ByTe_4  d, Pos;
    ByTe_4  Inc1, Inc2;
    ByTe_4  dX, dY;
    ByTe_4  MaxLen, Width; 
   
    dv  = parm.drv->dev;
    MaxLen = (dv->s_dimen[0] + 1.0) * (dv->s_dimen[1] + 1.0) + 0.5;
    ras = (u_ByTe_1 *)minfo.ras + MaxLen * plane;

    if (parm.ostyle == 0)
       Width = dv->s_dimen[0] + 1.0;
    else
       Width = dv->s_dimen[1] + 1.0;

    dX = abs(x1 - x2);                                /* slope along X      */
    dY = abs(y1 - y2);                                /* slope along Y      */

    /************************************************************************/
    /* Since the line is going to be drawn by incrementing along the Xaxis, */ 
    /* we have to set some stuff up to make sure all the incrementing is    */
    /* done correctly.                                                      */
    /************************************************************************/

    if (x1 > x2)
    {
       X = x2;                                        /* starting X         */
       Y = y2;                                        /* starting Y         */
       Xend = x1;                                     /* ending X           */
       Yinc = (dY == 0) ? 0 : (y2 > y1) ? -1 : 1;
    }
    else 
    {
       X = x1;                                        /* starting X         */
       Y = y1;                                        /* starting Y         */
       Xend = x2;                                     /* ending X           */
       Yinc = (dY == 0) ? 0 : (y2 > y1) ? 1 : -1;
    }

    /************************************************************************/
    /* Set up the Bresenham incrementers                                    */
    /************************************************************************/

    Inc1 = 2 * dY;
    d = Inc1 - dX;
    Inc2 = 2 * (dY - dX);

    Pos = X + Width * Y;
    if (Pos < MaxLen)
       *(ras + Pos) = color;

    /************************************************************************/
    /* Increment from the starting x to the ending x and do the Bresenham   */
    /* thing each time through.                                             */
    /************************************************************************/

    while (X++ < Xend)
    {
       if (d < 0)
	  d += Inc1;
       else 
       {
	  Y += Yinc;
	  d += Inc2;
       }

       Pos = X + Width * Y;
       if (Pos < MaxLen)
          *(ras + Pos) = color;
    }
}
