#include "gph_str.h"
#include "gph_ansi.h"
#define   RASTER
#include "gph_ansi_dr.h"

  /*************************************************************************/
  /* This function analyzes the coordinates of the line and decides which  */
  /* of the two line-drawing algorithms to use - either RasterX or RasterY */
  /* RasterX() draws the line as it increments along the x-axis and cannot */
  /* draw lines that are more vertical than horizontal. RasterY() is the   */
  /* reverse of this and can not draw lines that are more horizontal than  */
  /* vertical.                                                             */
  /*************************************************************************/

static ByTe_1 rcsid[] = "$Id: RasterLine.c,v 1.1 1999/11/21 10:07:06 chris.gurgiolo.b2r Stab chrisg $";

void RasterLine (ReaL_4 *data, ByTe_2 npts, ByTe_1 plane)
{
    extern struct config parm;
    register ReaL_4 *pos, *end;
   
    ByTe_2 x1, y1, x2, y2;

    u_ByTe_1  color;
   
    if (plane == 0)
       color = parm.l_color * parm.drv->ctb->c_scale;
    else
    {
       if (plane == 3)
       {
          color = parm.f_color * parm.drv->ctb->c_scale;
          plane = 0;
       }
       else
       {
          color = (plane == 1) ? 1 : 0;
          plane = 1;
       }
    }

    pos = data;
    end = data + 2 * npts;

    x1 = (ByTe_2) *pos++;
    y1 = (ByTe_2) *pos++;
    for ( ; pos < end; )
    {
       x2 = (ByTe_2) *pos++;
       y2 = (ByTe_2) *pos++;

       if (abs(x2 - x1) < abs(y2 - y1))
          RasterY (x1, y1, x2, y2, color, plane);
       else 
          RasterX (x1, y1, x2, y2, color, plane);

       x1 = x2;
       y1 = y2;
    }
}
