#include "gph_str.h"
#include "gph_ansi.h"
#define   RASTER
#include "gph_ansi_dr.h"

static ByTe_1 rcsid[] = "$Id: RasterFill.c,v 1.1 1999/11/21 10:07:06 chris.gurgiolo.b2r Stab chrisg $";

void RasterFill (ByTe_2 Xmin, ByTe_2 Ymin, ByTe_2 Xmax, ByTe_2 Ymax)
{
    extern struct config parm;
    extern struct memory minfo;

    struct scr_info *dv;
    register u_ByTe_1 *c1, *c2, *c3, *c4;
    ByTe_4  X, Y, XSave;
    ByTe_4  MaxLen, Width; 
    u_ByTe_1 color;
    ByTe_1 Off;
   
    dv  = parm.drv->dev;

    MaxLen = (dv->s_dimen[0] + 1.0) * (dv->s_dimen[1] + 1.0) + 0.5;
    if (parm.ostyle == 0)
       Width = dv->s_dimen[0] + 1.0;
    else
       Width = dv->s_dimen[1] + 1.0;
    color = parm.f_color * parm.drv->ctb->c_scale;

    c1 = (u_ByTe_1 *)minfo.ras;
    c2 = c1 + MaxLen;

    Y = Ymin;
    while (Y <= Ymax)
    {
       X = Xmin;
       Off = 1;
       c3 = c2 + X + Width * Y;
       c4 = c1 + X + Width * Y;
       while (X <= Xmax)
       {
          if (Off)
          {
             while (X <= Xmax && *c3 == 0)
             {
                 ++X;
                 ++c3;
                 ++c4;
             }
         
             while (X <= Xmax && *c3 == 1)
             {
                if (parm.fill == 0)
                   *c4 = color;
              
                ++X;
                ++c3;
                ++c4;
             }
             Off = 0;
          }
          else
          {
              XSave = X;
              while (X <= Xmax && *c3 != 1)
              {
                  ++X;
                  ++c3;
              }

              if (X <= Xmax)
                 while (XSave <= X)
                 {
                    ++XSave; 
                    *c4++ = color;
                 }
   
              while (X <= Xmax && *c3 == 1)
              {
                 if (parm.fill == 0)
                    *c4 = color;

                 ++X;
                 ++c3;
                 ++c4;
                 Off = 1;
              }
           }
       }
       ++Y;
   }
}
