#include <string.h>
#include "gph_opind.h"
#include "gph_str.h"
#include "gph_ansi.h"
#define   POSTSCRIPT
#include "gph_ansi_dr.h"

static ByTe_1 rcsid[] = "$Id: pc_setcolor.c,v 1.1 1999/11/21 09:14:49 chris.gurgiolo.b2r Stab chrisg $";

ByTe_1 pc_setcolor(ByTe_2 clr) 
{
    extern struct config parm;
    struct scr_info *dv;    
    register struct color *cl;  
    ByTe_1 str[40];
    static ByTe_2 last_col = -1;
    ByTe_2 color;

    ByTe_2 numcol;
    ReaL_4 *rgbPtr;

    dv = parm.drv->dev;
    numcol = dv->ctl;
    cl = parm.drv->ctb;

    color = (ByTe_2)(clr * cl->c_scale);

    /* swap black & white */

    if (color == 0)
      color = numcol - 1;
    else if (color == numcol - 1)
      color = 0;

    if (color == last_col)
       return(1);

    last_col = color;

    /* color is a value between 0 and numcol. It is used as an "index"
       to read values from memory, into which the rgb values were placed.
       The rgp pointer is mult. by 3, for there are 3 rgb values associated
       with each color.
    */

    if (parm.drv->w_cmd != NULL)
    {
       rgbPtr = (ReaL_4 *)parm.drv->w_cmd;
       rgbPtr += color * 3;

       sprintf (str, "%f ", *rgbPtr++);
       sprintf (&str[strlen(str)], "%f ", *rgbPtr++);
       sprintf (&str[strlen(str)], "%f setrgbcolor\n", *rgbPtr);
       write (parm.drv->fd,str,strlen(str));
    }

   /**********************************************************/
   /*  Default colors to black if color map not initialized  */
   /**********************************************************/

    else
    {
       if (color == numcol - 1)
          sprintf (str, "1.0 1.0 1.0 setrgbcolor\n");
       else
          sprintf (str, "0.0 0.0 0.0 setrgbcolor\n");

       write (parm.drv->fd,str,strlen(str));
    }

   return(1);
}
