#include <string.h>
#include "gph_opind.h"
#include "gph_str.h"
#include "gph_ansi.h"
#define   POSTSCRIPT
#include "gph_ansi_dr.h"

static ByTe_1 rcsid[] = "$Id: pc_poly.c,v 1.1 1999/11/21 09:14:49 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 pc_poly (ByTe_2 npts)
{
   extern struct memory minfo;
   extern struct config parm; 
   register ReaL_4 *pos, *end;
   ReaL_4 x, y;
   ByTe_1 str[80];

   if ((npts = scale_pts(npts,1)) < 4)
      return (0);

   pos = (ReaL_4 *) minfo.mxyz;
   end = pos + 2 * (npts - 1);

  /***********************/
  /* Move to first point */
  /***********************/

   x = *pos++;
   y = *pos++;
   sprintf(str, "%.2f %.2f m\n", x, y);
   write(parm.drv->fd, str, strlen(str));


  /****************************************************/
  /*  Enter the x,y coordinates and draw the polygon  */
  /****************************************************/

   for ( ; pos < end;)
   {
     x = *pos++;
     y = *pos++;
     sprintf(str, "%.2f %.2f l\n", x, y);
     write(parm.drv->fd, str, strlen(str));
   }

   /******************/
   /* Close the path */
   /******************/

   write(parm.drv->fd, "cl\n", 3);


   /*****************/
   /* Set the color */
   /*****************/

   pc_setcolor(parm.f_color);

   /********/
   /* Fill */
   /********/

   write(parm.drv->fd, "f\n", 2);

   return (1);
}
