#include <string.h>
#include "gph_opind.h"
#include "gph_str.h"
#include "gph_def.h"
#include "gph_ansi.h"
#define   POSTSCRIPT
#include "gph_ansi_dr.h"

static ByTe_1 rcsid[] = "$Id: pc_line.c,v 1.1 1999/11/21 09:14:49 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 pc_line (ByTe_2 npts, ByTe_1 from)
{
   extern struct memory minfo;
   extern struct config parm;
   struct window *wn;  
   register ByTe_1 *pp;
   register ReaL_4 *pos;
   ByTe_2 pts;
   ByTe_2 wrt = 0;
   static ReaL_4 prevx, prevy; 
   ByTe_1 str[80];

   pp = (ByTe_1 *)minfo.cmd;
   wn = parm.win;

   if ((npts = scale_pts(npts,from)) <= 0)
      return(-1);

   pos = (ReaL_4 *) minfo.mxyz;
   pp = (ByTe_1 *) minfo.mxyz + parm.cl_ofst;

   pts = npts;
  
  /*******************************************************/
  /*  Set the color                                      */
  /*******************************************************/

   pc_setcolor(parm.l_color);
  
  /********************/
  /*  Clear the path  */
  /********************/

   write(parm.drv->fd, "n\n", 2);

   if (npts == 2)
   {
      if ((pos[0] == pos[2]) && (pos[1] == pos[3]))
      {
         pos[2] += PCDOT;
         pos[3] += PCDOT;
      }
   }

  /************************************************************/
  /*  Gather all x,y coordinates, draw and move.              */
  /************************************************************/

   do
   {
      if (npts == pts)
	write(parm.drv->fd, ".5 sl\n", 6);

      if (*pp++ == 1)        /* If it's a draw */ 
      {	
         if (wrt == 0)
	 {
	    sprintf(str, "%.2f %.2f m\n", prevx, prevy);
	    write(parm.drv->fd, str, strlen(str));
         }
         sprintf(str, "%.2f %.2f l\n", *pos, *(pos+1)); 
	 write(parm.drv->fd, str, strlen(str));
      }
      else             /* If it's a move */ 
      {
         sprintf(str, "%.2f %.2f m\n", *pos, *(pos+1)); 
	 write(parm.drv->fd, str, strlen(str));
      }

      prevx = *pos++;
      prevy = *pos++;
      ++wrt;

     /*******************************************************************/
     /* The laser printer doesn't work it if is bombarded with too many */
     /*	commands at one time, so only 20 are sent at a time.            */
     /*******************************************************************/

      if (wrt == 21)
      { 
	write(parm.drv->fd, "st\n", 3);
        write(parm.drv->fd, ".5 sl\n", 6);	
	wrt = 0;
      }

   } while (--npts > 0);
   
 
   /********/
   /* Draw */
   /********/
  
   write(parm.drv->fd, "st\n", 3);  

   parm.gcr[0] = wn->r[0];
   parm.gcr[1] = wn->r[1];

   return(1);
}
