#include <string.h>
#include "gph_opind.h"
#include "gph_str.h"
#include "gph_ansi.h"
#define   POSTSCRIPT
#include "gph_ansi_dr.h"

static ByTe_1 rcsid[] = "$Id: pc_init.c,v 1.1 1999/11/21 09:14:49 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 pc_init (void)
{
   extern struct config parm;
   struct scr_info *dv;
   ReaL_4 row,col;

   dv = parm.drv->dev;
   parm.drv->w_cmd = NULL;

   /*******************************/
   /* include a header identifier */
   /*******************************/

   write(parm.drv->fd, "%!PS-Adobe-1.0\n", 15);
   write(parm.drv->fd, "%%Creator:B2R Graphics\n", 24);
   write(parm.drv->fd, "%%EndComments\n", 14);
   
   /*******************************************************/
   /* Enables the graphic to be printed in landscape mode */
   /*******************************************************/

   write(parm.drv->fd, "540 50 translate\n", 17);
   write(parm.drv->fd, "90 rotate\n", 10);
 
   /******************************************/
   /* Set up some aliases to optimize driver */
   /******************************************/

   write(parm.drv->fd, "/sg {setgray} def\n", 18);
   write(parm.drv->fd, "/st {stroke} def\n", 17);
   write(parm.drv->fd, "/sl {setlinewidth} def\n", 23);
   write(parm.drv->fd, "/co {copypage} def\n", 19);
   write(parm.drv->fd, "/n {newpath} def\n", 17);
   write(parm.drv->fd, "/m {moveto} def\n", 16);
   write(parm.drv->fd, "/l {lineto} def\n", 16);
   write(parm.drv->fd, "/sd {setdash} def\n", 18);
   write(parm.drv->fd, "/cl {closepath} def\n", 20);
   write(parm.drv->fd, "/f {fill} def\n", 14);
   write(parm.drv->fd, "/a {arc} def\n", 13);
   write(parm.drv->fd, "/sh {show} def\n", 15);
   
   row = dv->s_dimen[1] + 1.0;
   col = dv->s_dimen[0] + 1.0;
   dv->pix_sz[0]    = 32768.0 / (dv->s_dimen[0] + 1);
   dv->pix_sz[1]    = 32768.0 / (dv->s_dimen[1] + 1);
   if (dv->s_dimen[1] > dv->s_dimen[0])
   {
      dv->mk_sq[0] = (row / col) * dv->p_dimen[1] / dv->p_dimen[0];
      dv->mk_sq[1] = 1.0;
   }
   else
   {
      dv->mk_sq[0] = 1.0;
      dv->mk_sq[1] = (col / row) * dv->p_dimen[0] / dv->p_dimen[1];
   }

   dv->attri = 1;  /* always hard font */

   return(1);
}
