#include <string.h>
#include <math.h>
#include "gph_opind.h"
#include "gph_str.h"
#include "gph_ansi.h"
#define   POSTSCRIPT
#include "gph_ansi_dr.h"

/*********************************************************************
*  pc_sshow - starts/stops the postscript show command
*********************************************************************/

static ByTe_1 rcsid[] = "$Id: pc_hdfont.c,v 1.1 1999/11/21 09:14:49 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 pc_hdfont (ReaL_4 x, ReaL_4 y, ReaL_4 phi, ReaL_4 theta, ReaL_4 rot,
                ByTe_1 hv, ByTe_1 just, ByTe_1 *string, ByTe_2 len, ByTe_2 clr)
{
   extern struct config parm;
   ReaL_4 xx, yy;
   static ByTe_4 cnt=0;
   ByTe_4 fsize; 
   ReaL_4 char_off_x, char_off_y, char_off; 
   ReaL_4 tx, ty;
   ReaL_4 N;
   ByTe_1 move[200];
   ByTe_1 width_string[80];
   ByTe_1 tmp_str[120];
   ByTe_1 *c1;
   ByTe_1 one[80];

   ByTe_1 *mv   = "%.2f %.2f m\n";
   ByTe_1 *mvx1 = "%.2f (%s) stringwidth pop 2 div %f mul sub\n";
   ByTe_1 *mvy1 = "%.2f (%s) stringwidth pop 2 div %f mul sub m\n";
   ByTe_1 *mvx2 = "%.2f (%s) stringwidth pop %f mul sub\n";
   ByTe_1 *mvy2 = "%.2f (%s) stringwidth pop %f mul sub m\n";
   
   cnt++; 

   if (len < 0)
      len = strlen (string);

   if (len == 0)  /* Null string */
      return(0);

   if (parm.ostyle == 1)
      phi -= 90.0; 


  /*****************************************************/
  /*  Get the x,y coordinates in screen coordinates    */
  /*****************************************************/

   xx = x;
   yy = y;
   scale_one(&xx,&yy);
   tx = xx;
   ty = yy;


  /*****************/
  /* Set the color */
  /*****************/

   pc_setcolor(clr);

  /********************/
  /* Setting the font */
  /********************/

  fsize = pc_csize();

  char_off = (ReaL_4)fsize / 2.86 ;
  char_off_x = ((ReaL_4)fsize / 2.86)*sine(phi) ;
  char_off_y = ((ReaL_4)fsize / 2.86)*cosin(phi) ;
  
  pc_findSymb (string, fsize, 1);

   /* move for the proper justification */

   if (hv == 0)
   {
      switch (just) {
      case -1:
        sprintf (move, mv, tx + char_off_x, ty - char_off_y);
      break;
      case 0:
        pc_strWidth( width_string, string);
        pc_mark (width_string, tmp_str);
        sprintf (move, mvx1, tx + char_off_x, tmp_str, cosin(phi));
        write(parm.drv->fd, move, strlen(move) );
        sprintf (move, mvy1, ty - char_off_y, tmp_str, sine(phi) );
      break;
      case 1:
        pc_strWidth( width_string, string);
        pc_mark (width_string,tmp_str);
        sprintf (move, mvx2, tx + char_off_x, tmp_str, cosin(phi));
        write(parm.drv->fd, move, strlen(move) );
        sprintf (move, mvy2, ty - char_off_y, tmp_str, sine(phi) );
      break;
      } /* switch */

      write(parm.drv->fd, move, strlen(move) );

  /******************************************************************/
  /* Rotation                                                       */
  /******************************************************************/

      sprintf (move, "%f rotate \n", phi);
      write(parm.drv->fd, move, strlen(move) );

  /******************************************************************/
  /* decode the string for symbols, writing the postscript output   */
  /* commands for both the text and symbols.                        */
  /******************************************************************/

      pc_findSymb (string, fsize, 0);

      sprintf (move, "%f rotate \n", -phi);
      write(parm.drv->fd, move, strlen(move) );
   }
   else
   {
      c1 = string;
      N = 1.0;

      while (*c1 != 0)
      {
         xx = char_off_x * pc_hvcor (*c1);
         one[0] = *c1++;
         one[1] = 0;
         switch (just) 
         {
            case -1:
               sprintf (move, mv, tx + N * xx, ty - N * char_off_y);
            break;
            case 0:
               pc_strWidth( width_string, one);
               pc_mark (width_string, tmp_str);
               sprintf (move, mvx1, tx + char_off_x, tmp_str, cosin(phi));
               write(parm.drv->fd, move, strlen(move) );
               sprintf (move, mvy1, ty - N * char_off_y, tmp_str, sine(phi) );
            break;
            case 1:
               pc_strWidth( width_string, one);
               pc_mark (width_string,tmp_str);
               sprintf (move, mvx2, tx + char_off_x, tmp_str, cosin(phi));
               write(parm.drv->fd, move, strlen(move) );
               sprintf (move, mvy2, ty - N * char_off_y, tmp_str, sine(phi) );
            break;
         } /* switch */
 
         N += 2.8;

         write(parm.drv->fd, move, strlen(move) );

  /******************************************************************/
  /* Rotation                                                       */
  /******************************************************************/

         sprintf (move, "%f rotate \n", phi);
         write(parm.drv->fd, move, strlen(move) );

  /******************************************************************/
  /* pc_decode the string for symbols, writing the postscript output  */
  /*  commands for both the text and symbols.                       */
  /******************************************************************/

         pc_findSymb (one, fsize, 0);

         sprintf (move, "%f rotate \n", -phi);
         write(parm.drv->fd, move, strlen(move) );
      }
   }
   return(1);
}
