#include <string.h>
#include <math.h>
#include "gph_opind.h"
#include "gph_str.h"
#include "gph_ansi.h"
#define   POSTSCRIPT
#include "gph_ansi_dr.h"

static ByTe_1 rcsid[] = "$Id: pc_findSymb.c,v 1.1 1999/11/21 09:14:49 chris.gurgiolo.b2r Stab chrisg $";

void pc_findSymb (ByTe_1 *str, ByTe_4 fsize, ByTe_1 do_once)
{
  extern struct config parm;

  ByTe_1 newstr[200];       /* string to hold text to output */
  ByTe_1 symbstr[200];      /* string to hold 1 symbol to decode later */
  ByTe_1 *sptr;             /* pointer to entire string */
  ByTe_1 charfont[80];
  ByTe_1 symbfont[80];
  ByTe_1 dingfont[80];
  ByTe_1 *Helvetica = "/Helvetica findfont %d scalefont setfont \n";
  ByTe_1 *Symbol =    "/Symbol findfont %d scalefont setfont \n";
  ByTe_1 *Dingbats =  "/Dingbats findfont %d scalefont setfont \n";
  ByTe_4  more;              /* more data to process? */
  ByTe_4  font_type;         /* 0=charfont, 1=symfont */
  ByTe_4  norm_char;         /* in symbol mode, 1 = norm charcater */
  ByTe_4  sup_lev = 0;       /* superscript level */
  ReaL_4 sup_mode = 1.0;   /* super_script = 1.0 subscript = -1.0 */
  ReaL_4 fsize_temp;       /* temporary fsize value */
  ByTe_4 wait_for_term=0;    /* Wait for } */
  ByTe_1 Ftl, Ftc;
  ByTe_2 state;

  sptr = str;
  newstr[0] = '\0';
  symbstr[0] = '\0';
  state = 0;
  more = 1;
  font_type = 1;

  /* loop over the entire string */
  do 
  {
    switch (*sptr) 
    {
       case 123:
          wait_for_term = 1;
          break;
       case 125:
          wait_for_term = 0;
          break;
       case 39: /* single quote for symbols */
          switch (state) 
          {
             case 0:
                fsize_temp = fsize;
                sprintf (charfont, Helvetica, fsize);
                sprintf (symbfont, Symbol, fsize);
                sprintf (dingfont, Dingbats, fsize);
                if (font_type)
                {
                   font_type = 0;
                   if ((Ftl = pc_dings (str+1)) == 1)
	               write (parm.drv->fd, dingfont, strlen(dingfont) );
                   else
	               write (parm.drv->fd, symbfont, strlen(symbfont) );
	           state = 2;
                }
                else 
                {
                   font_type = 1;
	           state = 1;
	           write (parm.drv->fd, charfont, strlen(charfont) );
                }
                if (do_once)
                   return;
	        pc_sshow (1);
	        break;

             case 1:
	        if (newstr[0]) 
                {
	           write (parm.drv->fd, newstr, strlen(newstr) );
	           newstr[0] = '\0';
	           pc_sshow (2);
	        }
	        state = 2;
	        write (parm.drv->fd, symbfont, strlen(symbfont) );
	        pc_sshow (1);
	        break;

             case 2:
                Ftc = pc_dings (symbstr);
                if (Ftc != Ftl)
                {
	           pc_sshow (2);
                   Ftl = Ftc;
                   if (Ftc)
                   {
                      sprintf (dingfont, Dingbats, (ByTe_2)fsize); 
	              write (parm.drv->fd, dingfont, strlen(dingfont) );
                   }
                   else
                   {
                      sprintf (symbfont, Symbol, (ByTe_2)fsize); 
	              write (parm.drv->fd, symbfont, strlen(symbfont) );
                   }
	           pc_sshow (0);
                }

	        norm_char = pc_decodeSymb (symbstr); /* blank check (~) */
                if (norm_char == 1)
                {
                   pc_sshow (3);
	           write (parm.drv->fd, charfont, strlen(charfont) );
	           pc_sshow (0);
	           write (parm.drv->fd, symbstr, strlen(symbstr) );
                   pc_sshow (2);
                   if ( sup_lev )
                   {
                      fsize_temp = fsize_temp * 1.5;
	              sprintf (symbstr,"0 %d rmoveto\n",
                            (ByTe_2) (-fsize_temp*sup_mode/2.0));
	              write (parm.drv->fd, symbstr, strlen(symbstr) );
                      sup_lev--;
                      sprintf (charfont, Helvetica, (ByTe_2)fsize_temp); 
                   }
                   if (Ftc)
                   {
                      sprintf (dingfont, Dingbats, (ByTe_2)fsize_temp); 
	              write (parm.drv->fd, dingfont, strlen(dingfont) );
                   }
                   else
                   {
                      sprintf (symbfont, Symbol, (ByTe_2)fsize_temp); 
	              write (parm.drv->fd, symbfont, strlen(symbfont) );
                   }
                   pc_sshow (1);
                }
                else 
                   if ((norm_char==2) || (norm_char==3))
                   {
                      sup_mode = (norm_char == 3 ) ? -.6 : 1.0;
                      pc_sshow (3);
	              sprintf (symbstr,"0 %d rmoveto\n",
                         (ByTe_2) (fsize_temp*sup_mode/2));
	              write (parm.drv->fd, symbstr, strlen(symbstr) );
                      sup_lev++;
                      fsize_temp = fsize_temp * 2.0 / 3.0;
                      sprintf (charfont, Helvetica, (ByTe_2)fsize_temp); 
                      if (Ftc)
                      {
                         sprintf (dingfont, Dingbats, (ByTe_2)fsize_temp); 
	                 write (parm.drv->fd, dingfont, strlen(dingfont) );
                      }
                      else
                      {
                         sprintf (symbfont, Symbol, (ByTe_2)fsize_temp); 
	                 write (parm.drv->fd, symbfont, strlen(symbfont) );
                      }
	              write (parm.drv->fd, symbfont, strlen(symbfont) );
                      pc_sshow (1);
                   }
	           else 
                   {
                      write (parm.drv->fd, symbstr, strlen(symbstr) );
                      wait_for_term = 0;
                      if ( sup_lev )
                      {
                         pc_sshow (3);
                         fsize_temp = fsize_temp * 1.5;
             	         sprintf (symbstr,"0 %d rmoveto\n",
                            (ByTe_2) (-fsize_temp*sup_mode/2.0));
	                 write (parm.drv->fd, symbstr, strlen(symbstr) );
                         sprintf (charfont, Helvetica, (ByTe_2)fsize_temp); 
                         if (Ftc)
                         {
                            sprintf (dingfont, Dingbats, (ByTe_2)fsize_temp); 
	                    write (parm.drv->fd, dingfont, strlen(dingfont));
                         }
                         else
                         {
                            sprintf (symbfont, Symbol, (ByTe_2)fsize_temp); 
	                    write (parm.drv->fd, symbfont, strlen(symbfont));
                         }
                         sup_lev--;
                         pc_sshow (1);
                      }
                   }
                   symbstr[0] = '\0';
	           pc_sshow (3);
	           state = 0;
	        break;
          }
          break;

       case ' ':
          switch (state) 
          {
             case 0:
                fsize_temp = fsize;
                sprintf (charfont, Helvetica, fsize); 
                sprintf (symbfont, Symbol, fsize);
	        state = 1;
	        write (parm.drv->fd, charfont, strlen(charfont) );
                if (do_once)
                   return;
	        pc_sshow (0);
	        strncat (newstr, sptr, 1);
	        break;

             case 1:
                if (*sptr == 40 || *sptr == 41 || *sptr == 92 || *sptr == 35)
	            strncat (newstr, "\\", 1);
	        strncat (newstr, sptr, 1);
	        break;

             case 2:
                Ftc = pc_dings (symbstr);
                if (Ftc != Ftl)
                {
	           pc_sshow (2);
                   Ftl = Ftc;
                   if (Ftc)
                   {
                      sprintf (dingfont, Dingbats, (ByTe_2)fsize); 
	              write (parm.drv->fd, dingfont, strlen(dingfont) );
                   }
                   else
                   {
                      sprintf (symbfont, Symbol, (ByTe_2)fsize); 
	              write (parm.drv->fd, symbfont, strlen(symbfont) );
                   }
	           pc_sshow (0);
                }
	        norm_char = pc_decodeSymb (symbstr); /* blank check (~) */
                if (norm_char==1)
                {
                   pc_sshow (3);
	           write (parm.drv->fd, charfont, strlen(charfont) );
	           pc_sshow (0);
	           write (parm.drv->fd, symbstr, strlen(symbstr) );
                   pc_sshow (2);
                   if (( !wait_for_term ) && sup_lev )
                   {
                      fsize_temp = fsize_temp * 1.5;
	              sprintf (symbstr,"0 %d rmoveto\n",
                         (ByTe_2) (-fsize_temp*sup_mode/2.0));
	              write (parm.drv->fd, symbstr, strlen(symbstr) );
                      sup_lev--;
                      sprintf (charfont, Helvetica, (ByTe_2)fsize_temp); 
                      if (Ftc)
                      {
                         sprintf (dingfont, Dingbats, (ByTe_2)fsize_temp); 
	                 write (parm.drv->fd, dingfont, strlen(dingfont));
                      }
                      else
                      {
                         sprintf (symbfont, Symbol, (ByTe_2)fsize_temp); 
	                 write (parm.drv->fd, symbfont, strlen(symbfont));
                      }
                   }
	           write (parm.drv->fd, symbfont, strlen(symbfont) );
                   pc_sshow (1);
                }
                else 
                   if ((norm_char==2) || (norm_char==3))
                   {
                      sup_mode = (norm_char == 3 ) ? -.6 : 1.0;
                      pc_sshow (3);
	              sprintf (symbstr,"0 %d rmoveto\n",
                        (ByTe_2) (fsize_temp*sup_mode/2));
	              write (parm.drv->fd, symbstr, strlen(symbstr) );
                      sup_lev++;
                      fsize_temp = fsize_temp * 2.0 / 3.0;
                      sprintf (charfont, Helvetica, (ByTe_2)fsize_temp); 
                      if (Ftc)
                      {
                         sprintf (dingfont, Dingbats, (ByTe_2)fsize_temp); 
	                 write (parm.drv->fd, dingfont, strlen(dingfont));
                      }
                      else
                      {
                         sprintf (symbfont, Symbol, (ByTe_2)fsize_temp); 
	                 write (parm.drv->fd, symbfont, strlen(symbfont));
                      }
                      pc_sshow (1);
                   }
	           else 
                   {
                      write (parm.drv->fd, symbstr, strlen(symbstr) );
                      if ( ( !wait_for_term ) && sup_lev )
                      {
                         pc_sshow (3);
                         fsize_temp = fsize_temp * 1.5;
	                 sprintf (symbstr,"0 %d rmoveto\n",
                            (ByTe_2) (-fsize_temp*sup_mode/2.0));
	                 write (parm.drv->fd, symbstr, strlen(symbstr) );
                         sprintf (charfont, Helvetica, (ByTe_2)fsize_temp); 
                         sprintf (symbfont, Symbol, (ByTe_2)fsize_temp); 
                         if (Ftc)
                         {
                            sprintf (dingfont, Dingbats, (ByTe_2)fsize_temp); 
	                    write (parm.drv->fd, dingfont, strlen(dingfont));
                         }
                         else
                         {
                            sprintf (symbfont, Symbol, (ByTe_2)fsize_temp); 
	                    write (parm.drv->fd, symbfont, strlen(symbfont));
                         }
                         sup_lev--;
                         pc_sshow (1);
                      }
                   }
	           symbstr[0] = '\0';
	           break;
          } /* switch state */
          break;

       case '~':
          switch (state) 
          {
             case 0:
                fsize_temp = fsize;
                sprintf (charfont, Helvetica, fsize); 
                sprintf (symbfont, Symbol, fsize);
	        state = 1;
	        write (parm.drv->fd, charfont, strlen(charfont) );
                if (do_once)
                   return;
	        pc_sshow (0);
	        strncat (newstr, sptr, 1);
	        break;

             case 1:
                if (*sptr == 40 || *sptr == 41 || *sptr == 92 || *sptr == 35)
	           strncat (newstr, "\\", 1);
	        strncat (newstr, sptr, 1);
	        break;

             case 2:
	        strncat (symbstr, " ", 1);
	        break;

          } /* switch state */
          break;

       case '\0':
          switch (state) 
          {
             case 1:
	        if (newstr[0]) 
                {
	           write (parm.drv->fd, newstr, strlen(newstr) );
	           pc_sshow (2);
	           newstr[0] = '\0';
	        }

          } /* switch state */
          more = 0;   /* set flag to exit string processing loop */
          break;

       default: /* alphanumeric text for strings */
          switch (state) 
          {
             case 0:
                fsize_temp = fsize;
                sprintf (charfont, Helvetica, fsize); 
                sprintf (symbfont, Symbol, fsize);
	        write (parm.drv->fd, charfont, strlen(charfont) );
                if (do_once)
                   return;
	        state = 1;
	        pc_sshow (0);
                if (*sptr == 40 || *sptr == 41 || *sptr == 92 || *sptr == 35)
	           strncat (newstr, "\\", 1);
	        strncat (newstr, sptr, 1);
        	break;

             case 1:
                if (*sptr == 40 || *sptr == 41 || *sptr == 92 || *sptr == 35)
	           strncat (newstr, "\\", 1);
	        strncat (newstr, sptr, 1);
	        break;

             case 2:
	        strncat (symbstr, sptr, 1);
	        break;

          } /* switch state */
          break;

     } /* switch *sptr */

     ++sptr;

  } while (more);
}
