#include <string.h>
#include <math.h>
#include "gph_str.h"
#include "gph_ansi.h"
#define   POSTSCRIPT
#include "gph_ansi_dr.h"

/*********************************************************************
*  pc_dings - returns a one if symble is a dingbat                   * 
*********************************************************************/

static ByTe_1 rcsid[] = "$Id: pc_dings.c,v 1.1 1999/11/21 09:14:49 chris.gurgiolo.b2r Stab chrisg $";

ByTe_1 pc_dings (ByTe_1 *symbstr)
{
  ByTe_4 sum;
  register ByTe_1 *c1, *c2;
  ByTe_1 status, Ts[20];
  ByTe_1 first = 1;

  sum = 0;
  c1 = symbstr;
  c2 = Ts;
  while (*c1 != 0) 
  {
    if (*c1 != 39 && *c1 != 32)
    {
        sum += *c1;
        *c2++ = *c1;
    }

    if (*c1 == 32)
    {
       if (first)
          first = 0;
       else
          break;
    }

    ++c1;
  }

  *c2 = 0;

  switch (sum) 
  {
     case 233: /*  BOX  */
        status = (strcmp (Ts, "BOX") == 0) ? 1 : 0;
     break;

     case 276: /*  FDIA  */
        status = (strcmp (Ts, "FDIA") == 0) ? 1 : 0;
     break;

     case 303: /*  FBOX  */
        status = (strcmp (Ts, "FBOX") == 0) ? 1 : 0;
     break;

     case 305: /*  BLOT  */
        status = (strcmp (Ts, "BLOT") == 0) ? 1 : 0;
     break;

     case 314: /*  STAR  */
        status = (strcmp (Ts, "STAR") == 0) ? 1 : 0;
     break;

     case 377: /*  FDTRI  */
        status = (strcmp (Ts, "FDTRI") == 0) ? 1 : 0;
     break;

     case 384: /*  FSTAR  */
        status = (strcmp (Ts, "FSTAR") == 0) ? 1 : 0;
     break;

     case 394: /*  FUTRI  */
        status = (strcmp (Ts, "FUTRI") == 0) ? 1 : 0;
     break;

     case 434: /*  CIRCLE  */
        status = (strcmp (Ts, "CIRCLE") == 0) ? 1 : 0;
     break;

     default:
        status = 0;
     break;
  }

  return (status);
}
