#include <string.h>
#include <math.h>
#include "gph_str.h"
#include "gph_ansi.h"
#define   POSTSCRIPT
#include "gph_ansi_dr.h"

/*********************************************************************
   pc_decodeSymb - pc_decode symbol takes a string representing a symbol,
     and returns the postscript code for that symbol.
*********************************************************************/

static ByTe_1 rcsid[] = "$Id: pc_decodeSymb.c,v 1.1 1999/11/21 09:14:49 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 pc_decodeSymb (ByTe_1 *symbstr)
{
  ByTe_4 sum, norm_char;
  ByTe_1 *strptr;

  sum = 0;
  strptr = symbstr;
  while (*strptr) 
    sum += *strptr++;
  norm_char = 0;
  switch (sum) {
  case 32: /*  space  */
    if (strcmp (symbstr, " ") == 0)
       strcpy (symbstr, " ");
    else norm_char = 1;
    break;
  case 358: /*  ALPHA, CIRCLE */
    if (strcmp (symbstr, "ALPHA") == 0)
       strcpy (symbstr, "\101");
    else norm_char = 1;
    break;
  case 518: /*  alpha  */
    if (strcmp (symbstr, "alpha") == 0)
      strcpy (symbstr, "\141");
    else norm_char = 1;
    break;
  case 284: /*  BETA  */
    if (strcmp (symbstr, "BETA") == 0)
      strcpy (symbstr, "\102");
    else norm_char = 1;
    break;
  case 412: /*  beta  */
    if (strcmp (symbstr, "beta") == 0)
      strcpy (symbstr, "\142");
    else norm_char = 1;
    break;
  case 355: /*  GAMMA  */
    if (strcmp (symbstr, "GAMMA") == 0)
      strcpy (symbstr, "\107");
    else norm_char = 1;
    break;
  case 515: /*  gamma  */
    if (strcmp (symbstr, "gamma") == 0)
      strcpy (symbstr, "\147");
    else norm_char = 1;
    break;
  case 362: /*  DELTA  */
    if (strcmp (symbstr, "DELTA") == 0)
      strcpy (symbstr, "\104");
    else norm_char = 1;
    break;
  case 522: /*  delta  */
    if (strcmp (symbstr, "delta") == 0)
      strcpy (symbstr, "\144");
    else norm_char = 1;
    break;
  case 538: /*  EPSILON  */
    if (strcmp (symbstr, "EPSILON") == 0)
      strcpy (symbstr, "\105");
    else norm_char = 1;
    break;
  case 762: /*  epsilon  */
    if (strcmp (symbstr, "epsilon") == 0)
      strcpy (symbstr, "\145");
    else norm_char = 1;
    break;
  case 308: /* chi & ZETA  */
    if (strcmp (symbstr, "chi") == 0)
      strcpy (symbstr, "\143");
    else if (strcmp (symbstr, "ZETA") == 0)
      strcpy (symbstr, "\132");
    else norm_char = 1;
    break;
  case 436: /*  zeta  */
    if (strcmp (symbstr, "zeta") == 0)
      strcpy (symbstr, "\172");
    else norm_char = 1;
    break;
  case 218: /*  ETA  */
    if (strcmp (symbstr, "ETA") == 0)
      strcpy (symbstr, "\110");
    else norm_char = 1;
    break;
  case 314: /*  eta & STAR  */
    if (strcmp (symbstr, "eta") == 0)
      strcpy (symbstr, "\150");
    else if (strcmp (symbstr, "STAR") == 0)
      strcpy (symbstr, "\113");
    else norm_char = 1;
    break;
  case 374: /*  THETA  */
    if (strcmp (symbstr, "THETA") == 0)
      strcpy (symbstr, "\121");
    else norm_char = 1;
    break;
  case 534: /*  theta  */
    if (strcmp (symbstr, "theta") == 0)
      strcpy (symbstr, "\161");
    else norm_char = 1;
    break;
  case 301: /*  IOTA  */
    if (strcmp (symbstr, "IOTA") == 0)
      strcpy (symbstr, "\111");
    else norm_char = 1;
    break;
  case 429: /*  iota  */
    if (strcmp (symbstr, "iota") == 0)
      strcpy (symbstr, "\151");
    else norm_char = 1;
    break;
  case 365: /*  KAPPA  */
    if (strcmp (symbstr, "KAPPA") == 0)
      strcpy (symbstr, "\113");
    else norm_char = 1;
    break;
  case 525: /*  kappa & PARTIAL  */
    if (strcmp (symbstr, "kappa") == 0)
      strcpy (symbstr, "\153");
    else if (strcmp (symbstr, "PARTIAL") == 0)
      strcpy (symbstr, "\266");
    else norm_char = 1;
    break;
  case 417: /*  LAMBDA  */
    if (strcmp (symbstr, "LAMBDA") == 0)
      strcpy (symbstr, "\114");
    else norm_char = 1;
    break;
  case 609: /*  lambda  */
    if (strcmp (symbstr, "lambda") == 0)
      strcpy (symbstr, "\154");
    else norm_char = 1;
    break;
  case 162: /*  MU  */
    if (strcmp (symbstr, "MU") == 0)
      strcpy (symbstr, "\115");
    else norm_char = 1;
    break;
  case 226: /*  mu  */
    if (strcmp (symbstr, "mu") == 0)
      strcpy (symbstr, "\155");
    else norm_char = 1;
    break;
  case 163: /*  NU  */
    if (strcmp (symbstr, "NU") == 0)
      strcpy (symbstr, "\116");
    else norm_char = 1;
    break;
  case 227: /*  nu  */
    if (strcmp (symbstr, "nu") == 0)
      strcpy (symbstr, "\156");
    else norm_char = 1;
    break;
  case 161: /*  XI  */
    if (strcmp (symbstr, "XI") == 0)
      strcpy (symbstr, "\130");
    else norm_char = 1;
    break;
  case 225: /*  xi & PHI  */
    if (strcmp (symbstr, "xi") == 0)
      strcpy (symbstr, "\170");
    else if (strcmp (symbstr, "PHI") == 0)
      strcpy (symbstr, "\106");
    else norm_char = 1;
    break;
  case 535: /*  OMICRON  */
    if (strcmp (symbstr, "OMICRON") == 0)
      strcpy (symbstr, "\117");
    else norm_char = 1;
    break;
  case 759: /*  omicron  */
    if (strcmp (symbstr, "omicron") == 0)
      strcpy (symbstr, "\157");
    else norm_char = 1;
    break;
  case 153: /*  PI  */
    if (strcmp (symbstr, "PI") == 0)
      strcpy (symbstr, "\120");
    else norm_char = 1;
    break;
  case 217: /*  pi  */
    if (strcmp (symbstr, "pi") == 0)
      strcpy (symbstr, "\160");
    else norm_char = 1;
    break;
  case 233: /*  RHO  */
    if (strcmp (symbstr, "RHO") == 0)
      strcpy (symbstr, "\122");
    else if (strcmp (symbstr, "BOX") == 0)
      strcpy (symbstr, "\162");
    else norm_char = 1;
    break;
  case 329: /*  rho  */
    if (strcmp (symbstr, "rho") == 0)
      strcpy (symbstr, "\162");
    else norm_char = 1;
    break;
  case 369: /*  SIGMA  */
    if (strcmp (symbstr, "SIGMA") == 0)
      strcpy (symbstr, "\123");
    else norm_char = 1;
    break;
  case 529: /*  sigma  */
    if (strcmp (symbstr, "sigma") == 0)
      strcpy (symbstr, "\163");
    else norm_char = 1;
    break;
  case 234: /*  TAU or SUB */
    if (strcmp (symbstr, "TAU") == 0)
      strcpy (symbstr, "\124");
    else if (strcmp (symbstr, "SUB") == 0){
      strcpy (symbstr, "");
      norm_char = 3;
    }
    else norm_char = 1;
    break;
  case 330: /*  tau or sub */
    if (strcmp (symbstr, "tau") == 0)
      strcpy (symbstr, "\164");
    else if (strcmp (symbstr, "sub") == 0){
      strcpy (symbstr, "");
      norm_char = 3;
    }
    else norm_char = 1;
    break;
  case 554: /*  UPSILON  */
    if (strcmp (symbstr, "UPSILON") == 0)
      strcpy (symbstr, "\125");
    else norm_char = 1;
    break;
  case 778: /*  upsilon  */
    if (strcmp (symbstr, "upsilon") == 0)
      strcpy (symbstr, "\165");
    else norm_char = 1;
    break;
  case 212: /*  CHI  */
    if (strcmp (symbstr, "CHI") == 0)
      strcpy (symbstr, "\103");
    else norm_char = 1;
    break;
  case 236: /*  PSI  */
    if (strcmp (symbstr, "PSI") == 0)
      strcpy (symbstr, "\131");
    else norm_char = 1;
    break;
  case 332: /*  psi  */
    if (strcmp (symbstr, "psi") == 0)
      strcpy (symbstr, "\171");
    else norm_char = 1;
    break;
  case 361: /*  OMEGA  */
    if (strcmp (symbstr, "OMEGA") == 0)
      strcpy (symbstr, "\127");
    else norm_char = 1;
    break;
  case 521: /*  omega  */
    if (strcmp (symbstr, "omega") == 0)
      strcpy (symbstr, "\167");
    else norm_char = 1;
    break;
  case 126: /*  ~  */
    if (strcmp (symbstr, "~") == 0)
      strcpy (symbstr, "\176");
    else norm_char = 1;
    break;
  case 248: /*  || or SUP */
    if (strcmp (symbstr, "||") == 0)
      strcpy (symbstr, "\174\174");
    else if (strcmp (symbstr, "SUP") == 0){
      strcpy (symbstr, "");
      norm_char = 2;
    }
    else norm_char = 1;
    break;
  case 344: /* sup */
    if (strcmp (symbstr, "sup") == 0){
      strcpy (symbstr, "");
      norm_char = 2;
    }
    else norm_char = 1;
    break;
  case 123: /*  >=  */
    if (strcmp (symbstr, ">=") == 0)
      strcpy (symbstr, "\263");
    else norm_char = 1;
    break;
  case 121: /*  <=  */
    if (strcmp (symbstr, "<=") == 0)
      strcpy (symbstr, "\243");
    else norm_char = 1;
    break;
  case 105: /*  <-  */
    if (strcmp (symbstr, "<-") == 0)
      strcpy (symbstr, "\254");
    else norm_char = 1;
    break;
  case 122: /*  ==  */
    if (strcmp (symbstr, "==") == 0)
      strcpy (symbstr, "\272");
    else norm_char = 1;
    break;
  case 94: /*  !=  */
    if (strcmp (symbstr, "!=") == 0)
      strcpy (symbstr, "\271");
    else norm_char = 1;
    break;
  case 107: /*  ->  */
    if (strcmp (symbstr, "->") == 0)
      strcpy (symbstr, "\256");
    else norm_char = 1;
    break;
  case 214: /*  ANG  */
    if (strcmp (symbstr, "ANG") == 0)
      strcpy (symbstr, "\320");
    else norm_char = 1;
    break;
  case 213: /*  DEL  */
    if (strcmp (symbstr, "DEL") == 0)
      strcpy (symbstr, "\321");
    else norm_char = 1;
    break;
  case 235: /*  INT  */
    if (strcmp (symbstr, "INT") == 0)
      strcpy (symbstr, "\362");
    else norm_char = 1;
    break;
  case 221: /*  INF  */
    if (strcmp (symbstr, "INF") == 0)
      strcpy (symbstr, "\245");
    else norm_char = 1;
    break;
  case 228: /*  PPD  */
    if (strcmp (symbstr, "PPD") == 0)
      strcpy (symbstr, "\136");
    else norm_char = 1;
    break;
  case 305: /*  BLOT  */
    if (strcmp (symbstr, "BLOT") == 0)
      strcpy (symbstr, "\154");
    else norm_char = 1;
    break;
  case 298: /*  CDOT  */
    if (strcmp (symbstr, "CDOT") == 0)
      strcpy (symbstr, "\327");
    else norm_char = 1;
    break;
  case 286: /*  GRAD  */
    if (strcmp (symbstr, "GRAD") == 0)
      strcpy (symbstr, "\321");
    else norm_char = 1;
    break;
  case 321: /*  PROP & phi */
    if (strcmp (symbstr, "PROP") == 0)
      strcpy (symbstr, "\265");
    else if (strcmp (symbstr, "phi") == 0)
      strcpy (symbstr, "\146");
    else norm_char = 1;
    break;
  case 386: /*  INTER & TIMES */
    if (strcmp (symbstr, "INTER") == 0)
      strcpy (symbstr, "\307");
    else if (strcmp (symbstr, "TIMES") == 0)
      strcpy (symbstr, "\264");
    else norm_char = 1;
    break;
  case 393: /*  UNION  */
    if (strcmp (symbstr, "UNION") == 0)
      strcpy (symbstr, "\310");
    else norm_char = 1;
    break;
  case 474: /*  APPROX  */
    if (strcmp (symbstr, "APPROX") == 0)
      strcpy (symbstr, "\273");
    else norm_char = 1;
    break;
  case 222: /*  VEC  */
    if (strcmp (symbstr, "VEC") == 0)
      strcpy (symbstr, "\256");
    else norm_char = 1;
    break;
  case 276: /*  FDIA  */
    if (strcmp (symbstr, "FDIA") == 0)
      strcpy (symbstr, "\165");
    else norm_char = 1;
    break;
  case 303: /*  FBOX  */
    if (strcmp (symbstr, "FBOX") == 0)
      strcpy (symbstr, "\156");
    else norm_char = 1;
    break;
  case 377: /*  FDTRI  */
    if (strcmp (symbstr, "FDTRI") == 0)
      strcpy (symbstr, "\164");
    else norm_char = 1;
    break;
  case 384: /*  FSTAR  */
    if (strcmp (symbstr, "FSTAR") == 0)
      strcpy (symbstr, "\110");
    else norm_char = 1;
    break;
  case 394: /*  FUTRI  */
    if (strcmp (symbstr, "FUTRI") == 0)
      strcpy (symbstr, "\163");
    else norm_char = 1;
    break;
  case 307: /*  DTRI  */
    if (strcmp (symbstr, "DTRI") == 0)
      strcpy (symbstr, "\321");
    else norm_char = 1;
    break;
  case 206: /*  DIA  */
    if (strcmp (symbstr, "DIA") == 0)
      strcpy (symbstr, "\340");
    else norm_char = 1;
    break;
  case 434: /*  CIRCLE  */
    if (strcmp (symbstr, "CIRCLE") == 0)
      strcpy (symbstr, "\155");
    else norm_char = 1;
    break;
  default: /* The symbol is to be treated as normal */
    norm_char = 1;
  } /* switch */
  return norm_char;
}
