/************************************************************************/
/*                                                                      */
/*  This routine trys to get a window dependent font size which can be  */
/*  used by the postscript hard font driver to put out reasonably sized */
/*  characters.                                                         */
/*                                                                      */
/************************************************************************/

#include "gph_str.h"
#include "gph_ansi.h"
#define   POSTSCRIPT
#include "gph_ansi_dr.h"

static ByTe_1 rcsid[] = "$Id: pc_csize.c,v 1.1 1999/11/21 09:14:49 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 pc_csize(void)
{
   extern struct config parm;
   extern struct memory   minfo;
   extern struct init_val ival;

   register struct graph  *gf, *gf_end;
   register struct window *w1, *w2, *wn_end;
   register struct scr_info  *dv;

   ReaL_4 xbase, lenx, leny;
   ReaL_4 clen, cy, csz, cbase;
   ByTe_4  cs;
   ByTe_1 gw;

      /**************************************************************/
      /*  Get a reasonably sized font for the full screen - this    */
      /*  was empirically done by Albert Lozano with the postscript */
      /*  matching about what the softfont puts out.                */
      /*  We begin at this point.  We will make the assumption that */
      /*  since the characters are square that at character size    */
      /*  1024 the y extension of the character is about the height */
      /*  of the window.  We also assume that the font sizes are    */
      /*  linear in font number                                     */
      /**************************************************************/

      dv = parm.drv->dev;
      cbase = 2.0 * 1024 / 2.86;
      xbase = 1.0 / dv->mk_sq[1];

      /**************************************************************/
      /*  At this point we have to worry about the virtual window   */
      /*  the characters are scaled according to.  There are three  */
      /*  basic choices - characters are output scaled to current   */
      /*  window, characters are output scaled to another window,   */
      /*  and characters are output as if virtual window is square. */
      /*  Since these characters are square we will consider all    */
      /*  windows to be square which allows us to ignore the last   */
      /*  possibility since it is covered all the time.  So lets    */
      /*  get the base window.                                      */
      /**************************************************************/

      w1 = NOMEM;
      if (parm.cstyle == 2)
      {
         if (parm.c_win < 0)
         {
            gw = -parm.c_win - 1;
            gf = (struct graph *)minfo.mgraf;
            gf_end = gf + ival.graphs;
            for (; gf < gf_end; ++gf)
            { 
               if (gf->plotnm == gw && gf->gwn->open == 1)
                  w1 = gf->gwn;
            }	
            if (w1 == NOMEM)
               w1 = parm.win; 
         }
         else
         {
            w2 = (struct window *)minfo.mwin;
            wn_end = w2 + ival.windows;
            for ( ; w2 < wn_end; ++w2)
            {
               if (w2->viewport == parm.c_win && w2->open == 1)
                  w1 = w2;
            }
            if (w1 == NOMEM)
               w1 = parm.win; 
         }
      } 
      else
         w1 = parm.win; 

      /**************************************************************/
      /*  At this point we have a window whose scaling we are going */
      /*  to use to get out character size. Note that if we could   */
      /*  not find the alternate window asked for or it was not     */
      /*  then we will use the scaling of the current window.       */
      /*                                                            */
      /*  Now the way the character size goes the following is to   */
      /*  be expected by the user.  First - in any character size   */
      /*  which is less that 1024, no character will exceed the     */
      /*  the window in either height or length.  Second, the       */
      /*  number of characters which can stretch across the window  */
      /*  in the horizontal direction is 1024/parm.csize.           */
      /*                                                            */
      /*  First get the window lengths on the screen.               */
      /**************************************************************/

      lenx = w1->real[3] - w1->real[0]; 
      leny = w1->real[4] - w1->real[1]; 

      /**************************************************************/
      /*  If the user got sneaky and wants the characters output in */
      /*  the window as if it were square then we may have to fore- */
      /*  shorten one of the axes                                   */
      /**************************************************************/

      if (parm.cstyle == 1)
      {
         cbase *= .75;
         if (lenx > leny)
            lenx = leny;
         
         else
            leny = lenx;
      }

      /**************************************************************/
      /*  To first order if all we worry about is the 2nd condition */
      /*  then we need just to find an effective font which will    */
      /*  put 1024/parm.csize characters across the window.         */
      /*                                                            */
      /*  So first what is the x length of one character?  And from */
      /*  that what is a first order font size to pick?             */
      /**************************************************************/

      clen = lenx * parm.csize / 1024.0;
      csz  = clen * cbase / xbase; 

      /**************************************************************/
      /*  OK but now we had better make sure that the font sized    */
      /*  picked won't exceed the window height and if it is then   */
      /*  reset the font size to max at the window height.  This    */
      /*  will mean that we will be able to fit more characters     */
      /*  across the window - thats probably OK.                    */
      /**************************************************************/
       
      cy = 1.0 * csz / cbase; 
      if (cy > leny)
         csz = leny * cbase;

      /**************************************************************/
      /*  Note that the font has got to be 1 or bigger or we get a  */
      /*  postscript error -- so make sure.                         */
      /**************************************************************/

      csz *= .90;
      cs = (csz < 1.0) ? 1 : csz + 0.5;
         
      return (cs);
}
