#include <string.h>
#include <stdlib.h>
#define GIF
#include "gph_str.h"
#include "gph_ansi.h"
#include "gph_ansi_dr.h"
#include "LocalGIF.h"

static ByTe_1 rcsid[] = "$Id: gif_init.c,v 1.1.1.1 2000/02/01 15:09:06 chrisg Exp chrisg $";

ByTe_4 gif_init (void)
{
   extern struct config parm;
   extern struct memory minfo;
   FILE *fp;
   struct dev_graph *dg;
   struct scr_info *dv;
   register ByTe_1 *c1, *cEnD;
   ReaL_4 x, y;
   ByTe_4 size;
   ByTe_1 str[10];
  
   parm.white = 255;
   parm.black = 0;

   dv = parm.drv->dev;
   dg = parm.drv;

   if (dv->s_dimen[0] > 0)
   {
      GiF.Width = dv->s_dimen[0];
      GiF.Height = dv->s_dimen[1];
   }
   else
   {
      GiF.Width = -1;
      if ((fp = fopen("data.GIF", "r")) != NULL)
      {
         fscanf(fp, "%s %hd %hd", str, &GiF.Width, &GiF.Height); 
         if (strcmp (str, "GIF") != 0)
            GiF.Width = -1;
         fclose(fp);
      }

      if (GiF.Width < 0)
      {
         GiF.Width = 800;
         GiF.Height = 600;
      }
   }

   dv->s_dimen[0] = GiF.Width - 1.0;
   dv->s_dimen[1] = GiF.Height - 1.0;
   x = (ReaL_4)GiF.Width;
   y = (ReaL_4)GiF.Height;

   size = 2 * GiF.Width * GiF.Height * parm.SSize.Csize + .5;

   if (dv->s_dimen[1] > dv->s_dimen[0])
   {
      dv->mk_sq[0] = (y / x) * dv->p_dimen[1] / dv->p_dimen[0];
      dv->mk_sq[1] = 1.0;
   }
   else
   {
      dv->mk_sq[0] = 1.0;
      dv->mk_sq[1] = (x / y) * dv->p_dimen[0] / dv->p_dimen[1];
   }

   dv->pix_sz[0] = 32768.0/x;
   dv->pix_sz[1] = 32768.0/y;
   dv->p_conv[0] = x/32768.0;
   dv->p_conv[1] = -y/32768.0;
   dv->p_conv[2] = 0.0;
   dv->p_conv[3] = y - 0.001;

   if ((minfo.ras = malloc (size)) == NULL)
   {
       fprintf (parm.error,"\nGFI_INIT -- NO MEMORY FOR RASTER TABLE"); 
       fclose (parm.error);
       end_graph();
       exit (1);
   }
   c1 = (ByTe_1 *)minfo.ras;
   cEnD = c1 + size;
   for ( ; c1 < cEnD; )
      *c1++ = 0;

   size = 1030 * parm.SSize.Ssize;
   if ((dg->w_cmd = malloc (size)) == NULL)
   {
       fprintf (parm.error,"\nGFI_INIT -- NO MEMORY FOR COLOR TABLE INFO"); 
       fclose (parm.error);
       end_graph();
       exit (1);
   }

   /************************************************************************/
   /*  Some early initialization                                           */
   /************************************************************************/

   GiF.HighCode = (1 << GiF.NumBits) - 1;
   GiF.ClearCode = 1 << (GiF.NumBits - 1);
   GiF.EOFCode = GiF.ClearCode + 1;
   GiF.FirstFree = GiF.ClearCode + 2;

   return (1);
}
