#define GIF
#include "gph_str.h"
#include "gph_ansi.h"
#include "gph_ansi_dr.h"
#include "GIFstr.h"

static ByTe_1 rcsid[] = "$Id: SendToGIF.c,v 1.1 1999/11/21 09:01:18 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 SendToGIF (ByTe_2 Item)
{
   extern struct GIFInfo GiF;

   u_ByTe_1 byte;

   /***********************************************************************/
   /* This function is responsible for taking the codes output by the gif */
   /* encoder and packing them into 8-bit bytes.  Tis a painful operation */
   /* because the codes can be anywhere from 9 to 12 bits long.  After    */
   /* this function has packed up all the bytes it can, it sends them to  */
   /* the DumpBuffer() function, which packs the bytes into yet another   */
   /* buffer while it waits to send them to disk.                         */
   /***********************************************************************/

   /***********************************************************************/
   /* Mask off all the garbage at the top of the accumulator leaving only */
   /* the total number of valid bits at the bottom.                       */
   /***********************************************************************/

   GiF.accumulator &= GiF.Mask[GiF.totalbits];
  
   /***********************************************************************/
   /* If there are already some bits in the accumulator, they are going   */
   /* to be at the low end, so leftshift the code up to get it just past  */
   /* the low part of the byte and or it in.                              */
   /***********************************************************************/

   if (GiF.totalbits > 0)
      GiF.accumulator |= (ByTe_4)Item << GiF.totalbits;
   else 
      GiF.accumulator = Item;

   /***********************************************************************/
   /* Adjust the totalbits to show that there are now more bits in the    */
   /* accumulator.  (The code that was just ored into the accumulator was */
   /* supposed to be exactly NumBits bits long.)                          */
   /***********************************************************************/

   GiF.totalbits += GiF.NumBits;

   /***********************************************************************/
   /* There must be at least 8 bits in the buffer now, so start masking   */
   /* off the low end byte of the accumulator, send it to the buffer, and */
   /* right shift the accumulator down by a byte.  Also, subtract 8 off   */
   /* the total number of bits because 8 bits were just yanked out of the */
   /* buffer.                                                             */
   /***********************************************************************/

   while (GiF.totalbits >= 8)
   {
      byte = GiF.accumulator & 0x000000ff;
      ToBuffer (byte, 0);
      GiF.accumulator >>= 8;
      GiF.totalbits -= 8;
   }

   /***********************************************************************/
   /* Check for code overflow or a clearflag                              */
   /***********************************************************************/

   if (GiF.FirstFree > GiF.HighCode || GiF.ClearFlag == 1)
   {
      if (GiF.ClearFlag == 1)
      {

      /********************************************************************/
      /* The clearflag means that this function should reset all the      */
      /* stuff it needs and then reset the clearflag to 0.                */
      /********************************************************************/
	  
	  GiF.NumBits = 9;
	  GiF.HighCode = (1 << GiF.NumBits) - 1;
	  GiF.ClearFlag = 0;
      }
      else 
      {

      /*********************************************************************/
      /* FirstFree is too high for the current number of bits, so bump up  */
      /* the number of bits and reset the highcode to reflect the change.  */
      /* (Highcode is the highest code that can be made with NumBits bits. */
      /*********************************************************************/

	 ++GiF.NumBits;
	 GiF.HighCode = (GiF.NumBits == 12) ? 1 << 12 : (1 << GiF.NumBits) -1;
      }
   }

   /***********************************************************************/
   /* If the code is an end of file code, dump everything to buffer, even */
   /* if it doesn't make a whole byte (if there are less than 8 bits, the */
   /* rest are filled with 0s), dump the entire buffer to disk            */
   /***********************************************************************/

   if (Item == GiF.EOFCode)
   {
      while (GiF.totalbits > 0)
      {
         byte = GiF.accumulator & 0x000000ff;
         ToBuffer (byte, 0);
	 GiF.accumulator >>= 8;
	 GiF.totalbits -= 8;
      }

      ToBuffer (byte, 2);
   }
   return (1);
}
