#define GIF
#include "gph_opind.h"
#include "gph_str.h"
#include "gph_ansi.h"
#include "gph_ansi_dr.h"
#include "GIFstr.h"

static ByTe_1 rcsid[] = "$Id: DumpImage.c,v 1.1 1999/11/21 09:01:18 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 DumpImage (void)
{
   extern struct config parm;
   extern struct memory minfo;
   extern struct GIFInfo GiF;

   struct dev_graph *dg;

   register ByTe_4  *l1, *lEnd;
   register u_ByTe_4  I;
   register u_ByTe_1  *c1;

   ByTe_4 HashSize = 5003;
   ByTe_4 HashShift = 5003;
   ByTe_4 HashTbl[5003];
   ByTe_4 MaxCode;
   ByTe_4 primary, secondary;
   ByTe_4 code;

   u_ByTe_2 CodeTbl[5003];
   ByTe_2 entry, color, X, Y, OffSet;

   u_ByTe_1  byte;
   ByTe_1 BailOut;
  
   dg = parm.drv;

   /***********************************************************************/
   /*  Clear Hash Table                                                   */
   /***********************************************************************/

   l1 = HashTbl;
   lEnd = HashTbl + HashSize;
   for ( ; l1 < lEnd;)
      *l1++ = -1;

   /***********************************************************************/
   /*  Obtain the HashShift                                               */
   /***********************************************************************/

   HashShift = 0;
   for (I = HashSize; I < 65536; I *= 2)
      HashShift++;

   HashShift = 8 - HashShift;

   MaxCode = 1 << GiF.MaxBits;

   /***********************************************************************/
   /* Get ready to process image                                          */
   /***********************************************************************/

   X = 0;
   Y = 0;
   OffSet = 0;
   c1 = (u_ByTe_1 *)minfo.ras;

   /***********************************************************************/
   /*  Bump the current X up 1 and go to next line if necessary           */
   /***********************************************************************/

   entry = *c1++;
   ++X;
   ++OffSet;
   if (X >= GiF.Width)
   {
      X = 0;
      ++Y;
   }

   byte = 8;                                        /* Initial code size  */
   write (dg->fd, &byte, 1);

   SendToGIF (GiF.ClearCode);                        

   /***********************************************************************/
   /* Loop Over The Image                                                 */
   /***********************************************************************/

   while (Y < GiF.Height)
   {
      ++X;
      ++OffSet;
      color = *c1++;
      if (X >= GiF.Width)
      {
         X = 0;
         ++Y;
      }

      /*******************************************************************/
      /* Combine the new pixel color with the last pixel color to make a */
      /* hash table code                                                 */
      /*******************************************************************/

      code = (ByTe_4)(((ByTe_4)color << GiF.MaxBits) + entry);

      /*******************************************************************/
      /* Calculate the code for primary hashing.                         */
      /*******************************************************************/

      primary = ((ByTe_4)color << HashShift) ^ entry;

      /*******************************************************************/
      /* Check to see if the code is already in the hashtable.           */
      /*******************************************************************/

      if (HashTbl[primary] == code)
	 entry = CodeTbl[primary];
      else 
      {
         if (HashTbl[primary] < 0)
	 {
	    SendToGIF (entry);
	    entry = color;
	       
	    if (GiF.FirstFree < MaxCode)
	    {
               CodeTbl[primary] = GiF.FirstFree;
               ++GiF.FirstFree;
               HashTbl[primary] = code;
            }
            else 
            {
               /*********************************************************/
               /* The codes are getting too high, so reset things.      */
               /*********************************************************/

               ResetHash (1, HashTbl, HashSize);
	    }
	 }
         else 
         {
          /**************************************************************/
	  /* There were problems finding the code in the hash table, so */
          /* do a secondary hash.                                       */
          /**************************************************************/

	     secondary = HashSize - primary;
	     if (primary == 0)
                secondary = 1;

	     do
             {

             /***********************************************************/
             /* Set BailOut to indicate that we don't want to quit out  */
             /* of the loop yet.                                        */
             /***********************************************************/

	         BailOut = 0;
		      
             /***********************************************************/
             /* Get the primary hash code in range.                     */
             /***********************************************************/

                if ((primary -= secondary) < 0)
	            primary += HashSize;

             /***********************************************************/
	     /* If the codes matched up this time, set the entry to be  */
             /* whatever was in the code table and set BailOut up so it */
             /* can get us out of the loop.                             */
             /***********************************************************/

	        if (HashTbl[primary] == code)
	        {
	            entry = CodeTbl[primary];
	            BailOut = 1;
                }

             /***********************************************************/
             /* If the codes don't match yet and an unused entry in the */
             /* hash table hasn't been found yet, keep going, otherwise */
             /* exit.                                                   */
             /***********************************************************/

             } while (BailOut != 1 && HashTbl[primary] >= 0);

          /**************************************************************/
          /* If bailout does not equal 1, the loop must have exited     */
          /* because it found an unused entry in the hash table, so     */
          /* deal with that.                                            */
          /**************************************************************/

           if (BailOut != 1)
           {
              SendToGIF (entry);
              entry=color;
     
              if (GiF.FirstFree < MaxCode)
              {
                 CodeTbl[primary] = GiF.FirstFree;
	         ++GiF.FirstFree;
                 HashTbl[primary] = code;
               }
	       else 
                  ResetHash (1, HashTbl, HashSize);
            }
         }
      }
   }

   SendToGIF(entry);                              /* last entry to GIF file */
   SendToGIF(GiF.EOFCode);                        /* EOF to GIF file        */
   byte = 0;
   write (dg->fd, &byte, 1);                      /* Image end to GIF file  */

   return (1);
}
