#include <math.h>
#include <string.h>
#include "gph_str.h"
#include "gph_ansi.h"
#include "gph_opind.h"
#include "cont_str.h"

static ByTe_1 rcsid[] = "$Id: line_num.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

void line_num()
{
   extern struct config parm;
   extern struct memory minfo;
   extern struct cont_disp cdisp;
   extern struct cont_info cinfo;
   extern struct cont_alloc cal;

   register ReaL_4 *fx, *fy, *fxn, *fyn, *fend;
   register ByTe_1  *c1;
   
   ReaL_4 *Xb, *Yb, cXsq;
   ReaL_4 Td;
   ReaL_4 dX, dY;
   ReaL_4 pD;
   ReaL_4 critX, critY;
   ReaL_4 L;
   ReaL_4 cz[2];
   ReaL_4 *Sx, *Sy, *Sa, *Sl, A;

   ByTe_2 j, skp, Off, Q;
   ByTe_2 StLen;
   ByTe_2 SaveSz;
   ByTe_2 NLabs = 0;

   ByTe_1 str[20];
   ByTe_1 nolabel;

   Sx = cal.sX + cdisp.times;                     /* label X position array  */
   Sy = cal.sY + cdisp.times;                     /* label Y position array  */
   Sa = cal.sA + cdisp.times;                     /* label rot angle array   */
   Sl = cal.sL + cdisp.times;                     /* label rot angle array   */

   skp = parm.win->dimen;                         /* data dimension          */
   fx = (ReaL_4 *)minfo.mxyz;                     /* x contour line pnts     */
   fy = fx + 1;                                   /* y contour line pnts     */
   fxn = fx + skp;                                /* next x contour line pnt */
   fyn = fy + skp;                                /* next y contour line pnt */
   fend = fx + cinfo.calls * skp;                 /* end of line segs        */

   Td = 0;                                        /* segment length          */
   for ( ; fxn < fend; fxn += skp, fyn += skp)    /* loop over data          */ 
   {
      dX = *fxn - *fx;                            /* contour X len           */
      dY = *fyn - *fy;                            /* contour Y len           */
      Td += sqrt(dX*dX + dY*dY);                  /* contour length          */
      fx = fxn;                                   /* beg x of next segment   */
      fy = fyn;                                   /* beg y of next segment   */
   }

   sprintf(str, cdisp.cnt_fmt, cinfo.clevel);     /* contour level label     */
   c1 = str;                                      /* ptr to label string     */
   while (*c1 != '\0' && *c1 == ' ')              /* loop over label string  */
     ++c1;                                        /* if blank - next char    */

   if ((StLen = strlen(c1)) == 0)                 /* if label is empty       */
      return;                                     /* nothing to do           */

   SaveSz = parm.csize;                           /* save current label size */
   parm.csize = cdisp.LnSz;                       /* label size              */

   get_chsz (cz);                                 /* get character sizes     */

   cXsq = cz[0] * cz[0];                          /* x character len sq      */
   critX = StLen * cz[0];                         /* x string len in window  */
   Td /= critX;                                   /* cont len in # of strs   */
   if (Td < 5.0)                                  /* big enough contour?     */
      return;                                     /* too small for label     */
   critY = cz[1] * cz[1] / 4.0;                   /* sq of str height        */

   NLabs = 1;                                     /* default one label       */
   Q = cdisp.times % 3;                           /* label offset position   */
   if (Td < 15.0)                                 /* only one label?         */
      Off = (Q + 1) * cinfo.calls / 5;            /* number of fifths in     */
   else
   {
      Off = (Q == 0) ? 5 : Q * cinfo.calls / 6;   /* number of sixths in     */
      ++NLabs;                                    /* do two labels           */
   }

   for (j = 0; j < NLabs; ++j)                    /* loop over labels        */
   {                                              /* BEGIN LABEL LOOP        */
      fx = (ReaL_4 *)minfo.mxyz + Off * skp;      /* x contour line pnts     */
      fy = fx + 1;                                /* y contour line pnts     */
      fxn = fx + skp;                             /* next x contour line pnt */
      fyn = fy + skp;                             /* next y contour line pnt */

      fxn = fx + skp;                             /* next x contour line pnt */
      fyn = fy + skp;                             /* next y contour line pnt */

      Xb = fx;                                    /* beginning X position    */
      Yb = fy;                                    /* beginning Y position    */
      L = 0.0;                                    /* no break in contour     */
      nolabel = 1;                                /* set label to no         */

      while (fxn < fend && nolabel)               /* get spot for label      */
      {
         dX = *fxn - *Xb;                         /* contour X len from beg  */
         dY = *fyn - *Yb;                         /* contour Y len from beg  */
         L = sqrt(dX*dX + dY*dY);                 /* linear contour length   */

         if (L >= critX)                          /* got space for label?    */
         {                                        /* yes!                    */ 
            pD = Excursion (Xb, fxn, skp, dX, dY, L);  /* get y excursion    */
            if (pD <= critY)                      /* contour in lab bounds?  */
            {                                     /* yes - good label        */
               *Sx++ = (*Xb + *fx) / 2.0;         /* save mid x of lab       */
               *Sy++ = (*Yb + *fy) / 2.0;         /* save mid y of lab       */

               A = 180.0 * atan2(dY, dX) / M_PI;  /* angle of label          */
               if (A > 90.0 || A < -90.0)         /* would be upside down?   */
                  A += 180.0;                     /* right it                */
               *Sa++ = A;                         /* save angle              */
               *Sl++ = cinfo.clevel;              /* save level              */
               ++cdisp.times;                     /* inc num of labels       */
               nolabel = 0;                       /* found label             */
            }
            else
            {
               Xb += skp;                         /* move up beg X point     */
               Yb += skp;                         /* move up beg Y point     */
            }
         }

         fx = fxn;                                /* beg x of next segment   */
         fy = fyn;                                /* beg y of next segment   */
         fxn += skp;                              /* ending x of next of seg */ 
         fyn += skp;                              /* ending y of next of seg */ 
      }

      if (NLabs == 2)                             /* set for for lab 2?      */
      {                                           /* have to do that         */
         Q += 3;                                  /* skip half ahead         */
         Off = Q * cinfo.calls / 6;               /* number of sixths in     */
         fx = (ReaL_4 *)minfo.mxyz + Off * skp;   /* x contour line pnts     */
         fxn += cinfo.calls / 3;                  /* 1/3 more to end of last */
         if (fxn > fx)                            /* min 1/3 contour space?  */
            break;                                /* no - we're done         */
      }
   }                                              /* END LABEL LOOP          */
   SaveSz = parm.csize;                           /* replace old label size  */
   plt_corsys(0);                                
}

