/*** Returns the segment number connecting two contour grid points. ***/
/*** Also returns whether the segment is on the contour grid        ***/
/*** boundary.                                                      ***/
/***                                                                ***/
/*** For any grid point there are 3 possible segments - these are   ***/
/*** shown by                                                       ***/
/***                                                                ***/
/***                           .   .                                ***/
/***                           |  /                                 ***/
/***                        N+2 N+1                                 ***/
/***                           |/                                   ***/
/***                           .-N-.                                ***/
/***                                                                ***/

#include "cont_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: get_num.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";
 
void get_num(ByTe_4 *num, ByTe_4 pt1, ByTe_4 pt2, ByTe_1 *border)
{
   extern struct cont_info cinfo;
   extern struct cont_alloc cal;
   register ByTe_4 ptmax, ptmin;
   register ByTe_4 ptdiff;
   
   if (pt1 > pt2)
   {
      ptmax = pt1;
      ptmin = pt2;
   }
   else
   {
      ptmax = pt2;
      ptmin = pt1;
   }

   *border = 0;
   ptdiff = ptmax - ptmin;

   if (ptmin < (cinfo.nr)*(cinfo.nc-1))
   {
      *num = 3 * ptmin - 2 * ( (int) (ptmin/cinfo.nr));
      if (ptdiff == cinfo.nr)
      {
         if (((ptmin % cinfo.nr) == 0) || (((ptmin+1) % cinfo.nr) == 0))
            *border = 1;
      }
      else 
      {
         if (ptmax < cinfo.nr )
            *border = 1;

         *num += (ptdiff == 1) ? 2 : 1;
      }
   }
   else
   {
      *num = ptmin + 2 * (cinfo.nr - 1) * (cinfo.nc - 1);
      *border = 1;
   }
    
   if (*(cal.bad+pt1) == 1 || *(cal.bad+pt2) == 1)
      *border = 2;
}
