#include "cont_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: get_ids.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

void get_ids(ByTe_4 num, ByTe_4 *pt1, ByTe_4 *pt2)
{
  extern struct cont_info cinfo;

  register ByTe_4  SperR, Bseg, Nr;                        
  register ByTe_2 ds;

  ByTe_4 NC;

  SperR = 3 * cinfo.nr - 2;                            /* segments/mesh row  */
  NC = cinfo.nc - 1;                                   /* next to last col   */
  Nr = cinfo.nr;                                       /* fast row variable  */

  if (num >= SperR * NC)                               /* seg in last col?   */
  {                                                    /* yep!               */
     *pt1 = num - 2 * (Nr - 1) * NC;                   /* 1st point          */
     *pt2 = *pt1 + 1;                                  /* next point up      */
  }
  else
  {                                                    /* seg  in mesh       */
     *pt1 = (num + 2 * (num / SperR))/3;               /* 1st point          */
     *pt2 = *pt1;                                      /* beg of 2nd pnt     */
     Bseg = 3 * *pt1 - 2 * (*pt1 / Nr);                /* base horiz seg #   */
     ds = num - Bseg;                                  /* delta segment      */
     *pt2 += (ds == 0) ? Nr : (ds == 1) ? Nr + 1 : 1;  /* finish 2nd point   */
  }
}
