#include "cont_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: find_close.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

/*****************************************************************************/
/*                                                                           */
/*  Input a set of ordered data points (rectangular or spiral) with          */
/*  positions given by x,y, and a mesh point given by X,Y, and this routine  */
/*  will return the closest data point to the mesh point.  The input value   */
/*  max is the diagonal distance across a single mesh point.  If the minimum */
/*  distance found is 1.0e-10 times the diagonal mesh distance then the      */
/*  closest point and mesh are considered to be one and the same point. This */
/*  is indicated by returning the position as negative - 1.                  */
/*                                                                           */
/*****************************************************************************/

ByTe_4 find_close (ReaL_4 *x, ReaL_4 *y, ReaL_8 max, ByTe_4 npts, ReaL_4 X, 
                   ReaL_4 Y)
{
   register ReaL_4 *f1, *f2, *fend;
   register ByTe_4  pos;
   register ReaL_8 min;
   ReaL_8 dx, dy, dis;
   ByTe_4 close;

   close = 0;                                  /* initialize closest point  */

   f1    = x;                                  /* pointer to x data coords  */ 
   f2    = y;                                  /* pointer to y data coords  */
   fend  = f2 + npts;                          /* pointer to end of data    */

   dx = *f1++ - X;                             /* x dis from mesh point     */
   dy = *f2++ - Y;                             /* y dis from mesh point     */
   min = dx * dx + dy * dy;                    /* initial minimum distance  */
   pos = 0;                                    /* initial minimum position  */

   for (pos = 1; f2 < fend; ++pos)             /* loop over data            */
   {
       dx = *f1++ - X;                         /* x dis from mesh point     */
       dy = *f2++ - Y;                         /* y dis from mesh point     */
       dis = dx * dx + dy * dy;                /* sq of dis from mesh pt    */
       if (dis < min)                          /* minimum distance?         */
       {                                       /* yep!                      */
          close = pos;                         /* save position of minimum  */
          min = dis;                           /* reset minimum             */
       }
    }

    max *= 1.0e-10;
    if (min < max)
       close = -close - 1;

    return (close);
}
