/**************************************************************************/
/* This routine determines the color to be assigned any subell within     */
/* a given contour grid                                                   */
/**************************************************************************/

#include "gph_str.h"
#include "cont_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: cell_color.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

ByTe_2 cell_color (ByTe_4 bot, ByTe_4 side, ReaL_4 llz, ReaL_4 lrz, ReaL_4 urz, 
                  ReaL_4 ulz)
{

   extern struct cont_disp cdisp;

   ReaL_4 sm, Fc;
   ReaL_4 S;
   ReaL_4 A, B, C, D;
   ReaL_4 avg;
   ByTe_2 color;

/**************************************************************************/
/*  Algorithmh.  A given subgrid grid is assigned a color according to    */
/*  in the following algorithm.  The grid and its subcells are shown      */
/*  below.   The grid corners are marked by v's and the subcell being     */
/*  colored is marked with an X.                                          */
/*                                                                        */
/*                                 A    B                                 */
/*                     v  _  .  _  .  _  .  _  v                          */
/*                                                                        */
/*                     |     |     |     |     |                          */
/*                     .  _  .  _  .  _  .  _  .                          */
/*                                                                        */
/*                     |     |     |     |     |                          */
/*                     .  _  .  _  a  _  b  _  .                          */
/*                                                                        */
/*                     |     |     |  X  |     |                          */
/*                     .  _  .  _  c  _  d  _  .                          */
/*                                                                        */
/*                     |     |     |     |     |                          */
/*                     v  _  .  _  .  _  .  _  v                          */
/*                                                                        */
/*                                 C     D                                */
/*                                                                        */
/*  First, a linear interpolation in value is made along the top and      */
/*  bottom of the grid to give estimated values at the projection of the  */
/*  subcell corners (A, B, C, and D).  Then as set of linear              */
/*  interpolations in value is made between A-C and B-D to give a         */
/*  set of estimated values at the subcell corners (a, b, c, and d).      */
/*  These are averaged to give an value for the cell which is then        */
/*  converted to color using a linear interpolation between the maximum   */
/*  and minimum color bar values and the colors assigned to the maximum   */
/*  and minimum values.  Note that this routine makes the tacit           */
/*  assumption that the maximum value has a color of parm.red and the     */
/*  minimum value a color of parm.purple.                                 */
/**************************************************************************/

   sm = cdisp.smooth;                         /* subcells along grid edge */

   S = (lrz - llz)/sm;                        /* val slope along bot edge */
   C = S * bot + llz;                         /* estimate for C           */
   D = S * (bot + 1) + llz;                   /* estimate for D           */
   S = (urz - ulz)/sm;                        /* val slope along top edge */
   A = S * bot + ulz;                         /* estimate for A           */
   B = S * (bot + 1) + ulz;                   /* estimate for B           */

   S = (A - C)/sm;                            /* slope along A-C vertical */
   avg = S*side + C;                          /* value at c               */
   avg += S*(side + 1) + C;                   /* value at a               */
   S = (B - D)/sm;                            /* slope along B-D vertical */
   avg += S*side + D;                         /* value at d               */
   avg += S*(side + 1) + D;                   /* value at b               */

   avg /= 4.0;                                /* value for subcell        */

   Fc = cdisp.Xcol[1] + cdisp.Xcol[0] * avg;  /* floating point color     */
   if (Fc > cdisp.Xcol[2])                    /* greater than max?        */
      color = cdisp.Xcol[2];                  /* set to max               */
   else
      color = (Fc < cdisp.Xcol[3]) ? 0 : Fc; 

   return (color);                            /* return color             */
}
