#include "cont_str.h"
#include "gph_ansi.h"

/*****************************************************************************/
/*  This routine finds the 8 data points surrounding the data point which    */
/*  is located at the location C.  The location of these points in the data  */
/*  array are returned in the array Q.  The definitions are:                 */
/*                                                                           */
/*                     Q[3] ... Q[2] ... Q[1]                                */
/*                      .        .        .                                  */
/*                      .        .        .                                  */
/*                      .        .        .                                  */
/*                     Q[4] .... C  .... Q[0]                                */
/*                      .        .        .                                  */
/*                      .        .        .                                  */
/*                      .        .        .                                  */
/*                     Q[5] ... Q[6] ... Q[7]                                */
/*                                                                           */
/*  The routine returns a status byte S which indicates the position of the  */
/*  center point within the data mesh.  The values are                       */
/*                                                                           */
/*       0 - center point interior to mesh                                   */
/*       3 - center point on upper edge                                      */
/*       7 - center point on lower edge                                      */
/*                                                                           */
/*****************************************************************************/

static ByTe_1 rcsid[] = "$Id: QuadPntsCyc.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

ByTe_1 QuadPntsCyc (ByTe_4 C, ByTe_4 *Q)
{
   extern struct cont_info cinfo;
   register ByTe_4 *l1;
   register ByTe_4 L;
   register ByTe_4 R;

   ByTe_1 top_ok, bot_ok;
   ByTe_1 off_left = 0, off_right = 0;
   ByTe_1 S;

   R = C + 1;                                   /* one data point up         */
   top_ok = ((R % cinfo.Y) == 0) ? 0 : 1;       /* 1 more data row up?       */
   bot_ok = ((C % cinfo.Y) == 0) ? 0 : 1;       /* 1 more data row down?     */

   R = C + cinfo.Y;                             /* data to right of center   */
   if (R > cinfo.gridsize) {                    /* BEG FALL OFF MESH RIGHT   */
      R -= cinfo.gridsize;                      /* wrap around               */
      off_right = 1;                            /* set off right flag        */
   }                                            /* END FALL OFF MESH RIGHT   */

   L = C - cinfo.Y;                             /* data to left of center    */
   if (L < 0) {                                 /* BEG FALL OFF MESH LEFT    */
      L += cinfo.gridsize;                      /* wrap around               */
      off_left = 1;                             /* set off left flag         */
   }                                            /* END FALL OFF MESH LEFT    */

   l1 = Q;                                      /* pntr to output array      */

   *l1++ = R;                                   /* loc of right horiz pnt    */ 

   if (top_ok) {                                /* BEG UPPER POINTS OK       */
      *l1++ = R + 1;                            /* loc of right up diag pnt  */
      *l1++ = C + 1;                            /* loc of upper vert pnt     */
      *l1++ = L + 1;                            /* loc of left up diag pnt   */
   } else {                                     /* BEG NO UPPER POINTS       */
      *l1++ = -1;                               /* loc of right up diag pnt  */
      *l1++ = -1;                               /* loc of upper vert pnt     */
      *l1++ = -1;                               /* loc of left up diag pnt   */
   }                                            /* END UPPER POINTS          */

   *l1++ = L;                                   /* loc of left horiz pnt     */

   if (bot_ok) {                                /* BEG LOWER POINTS OK       */
      *l1++ = L - 1;                            /* loc of left down diag pnt */
      *l1++ = C - 1;                            /* loc of down vert pnt      */
      *l1++ = R - 1;                            /* loc of right dwn diag pnt */
   } else {                                     /* BEG NO LOWER POINTS       */
      *l1++ = -1;                               /* loc of right up diag pnt  */
      *l1++ = -1;                               /* loc of upper vert pnt     */
      *l1++ = -1;                               /* loc of left up diag pnt   */
   }                                            /* END LOWER POINTS          */

   S = (!top_ok) ? 3 : (!bot_ok) ? 7 : 0;       /* set return status         */

   *l1++ = (off_right) ? Q[0] : C;              /* min data loc of cell 0    */
   *l1++ = (off_left) ? C : Q[4];               /* min data loc of cell 1    */
   *l1++ = (off_left) ? Q[6] : Q[5];            /* min data loc of cell 2    */
   *l1 = (off_left) ? Q[7] : Q[6];              /* min data loc of cell 3    */

   return (S);
}
