#include "gph_str.h"
#include "gph_ansi.h"
#include "cont_str.h"
#include "gph_shortcut_defs.h"

static ByTe_1 rcsid[] = "$Id: MkContour.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

void MkContour(ByTe_1 wn, ReaL_4 *v, ReaL_4 *x, ReaL_4 *y, ReaL_4 *z, ByTe_4 N)
{
   extern struct config parm;
   extern struct cont_disp cdisp;
   extern struct cont_info cinfo;
   extern struct cont_map c_map;
   ByTe_2 W;
   ByTe_1 str[10];

   W = parm.white;

   cdisp.window = wn;
   cinfo.N = N;

   font (1);
   chr_size (10);
   clip(wn, 2);
   plt_color (0, W);

   if (cinfo.hold_grid == 0)                        /* new mesh?             */
   {                                                /* BEGIN BUILD MESH      */
      Init3DStuff(x, y, z);                         /* 3D initializations    */
      SetUpMem ();                                  /* memory allocation     */
      FindExtremes (v);                             /* max and min in data   */
      PreFilter (v, x, y, z);                       /* prefilter data        */
      EstablishGrid ();                             /* set up grid spacings  */
      FormMesh (v, x, y, z);                        /* make contour mesh     */
      CheckScaling ();                              /* get scaling           */
   }                                                /* END BUILD MESH        */

/**************************************************************************/
/*  If we are drawing a map and if the map outline is to underlay the     */
/*  contour output then draw it now                                       */
/**************************************************************************/

   if (cinfo.plot_fmt == 1 && c_map.map == 1)
      DrMaps();

   str[0] = 1;
   str[1] = 0;
   str[2] = cdisp.Cs;
   str[3] = 1;
   str[4] = 0;
   color_bar(99, wn, .9, .9, .0, .95, .95, 0., str,
                 cdisp.colmin, cdisp.colmax, cdisp.Xcol);

   if (cinfo.plot_fmt == 1)
      parm.univ = c_map.projection + 8;

   if (cdisp.output != 2)
   {
      if (cdisp.output != 1)
         ColorInGrid ();
/*
         if (cinfo.plot_fmt == 1 && cinfo.data_type == 4)
         if (cinfo.plot_fmt == 1)
             col_map(x, y);
          else
             col_cont();
*/
   }

   DisplayData (wn, v, x, y, z, cinfo.N);          /* Show data if appl. */
   DisplayMesh (wn);                               /* Show mesh if appl. */

   plt_color(0, W);
       
   if (cdisp.output != 0)
      gen_con();                                   /* Draw the lines */

   parm.univ = 0;

/**************************************************************************/
/*  If we are drawing a map and if the map outline is to overlay the      */
/*  contour output then draw it now                                       */
/**************************************************************************/

   if (cinfo.plot_fmt == 1 && c_map.map == 0)
      DrMaps();

/* Prepare for next set of data if it is the same type as this one */

   cinfo.second = (cinfo.same == 1) ? 1 : 0;

   if (cinfo.save_grid)
      PrntMesh ();
}
