#include "cont_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: InDataCell.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

/***************************************************************************/
/*                                                                         */
/*  This routine determines if the data point Rm is interior to, on the    */
/*  edge of, or exterior to the area bounded by the two vectors defined    */
/*  by Rc->R1 and Rc->R2.                                                  */
/*                                                                         */
/*  The determination is made from the cross products between the vector   */
/*  formed from Rc->R1 with Rc->Rm and Rc->Rm with Rc->R2.  If Rm lies     */
/*  between the two data cell vectors then both cross products will have   */
/*  the same sign.  In this case the routine returns a 0.  If Rm actually  */
/*  falls on one of the two vectors then the routine returns a 1 or 2      */
/*  depending on whether Rm fell on the vector formed with R1 or R2        */
/*  respectively.  If Rm is outside the two vectors the routine returns a  */
/*  -1.                                                                    */
/*                                                                         */
/***************************************************************************/

ByTe_1 InDataCell (ReaL_4 *Rc, ReaL_4 *Rm, ReaL_4 *R1, ReaL_4 *R2)
{
   ReaL_4 Xd, Yd;
   ReaL_4 Xm, Ym;
   ReaL_4 Cx1, Cx2;

   Xd = Rm[0] - Rc[0];                   /* X comp of vector Rc->Rm         */
   Yd = Rm[1] - Rc[1];                   /* Y comp of vector Rc->Rm         */
   Xm = R1[0] - Rc[0];                   /* Y comp of vector Rc->R1         */
   Ym = R1[1] - Rc[1];                   /* Y comp of vector Rc->R1         */
   Cx1 = Xm * Yd - Xd * Ym;              /* cross product (Rc->R1)x(Rc->Rm) */  

   Xm = R2[0] - Rc[0];                   /* Y comp of vector Rc->R2         */
   Ym = R2[1] - Rc[1];                   /* Y comp of vector Rc->R2         */
   Cx2 = Xd * Ym - Xm * Yd;              /* cross product (Rc->R2)x(Rc->Rm) */  

   if (Cx1 == 0.0)                       /* Rm on (Rc->R1) vector?          */
      return (1);                        /* yes - return 1                  */
   else
   {
      if (Cx2 == 0.0)                    /* Rm on (Rc->R2) vector?          */
         return (2);                     /* yes - return 2                  */
      else
      {
         if ((Cx1 > 0.0 && Cx2 > 0.0) ||(Cx1 < 0.0 && Cx2 < 0.0))
            return (0);
         else
            return (-1);
      }
   }
}
