#include "gph_str.h"
#include "gph_ansi.h"
#include "cont_str.h"

static ByTe_1 rcsid[] = "$Id: HollowCyc.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

void HollowSq (ReaL_4 *v, ReaL_4 *x, ReaL_4 *y, ByTe_4 iD, ByTe_4 Level)
{
   extern struct cont_info cinfo;
   extern struct cont_alloc cal;

   register ReaL_4 *f1, *f2, *f3, *f4, *f5, *fend;
   register ByTe_4  *l1, *l2, *lend;

   ReaL_4 *gV;
   ReaL_4 *X, *Y, *Xend, *Yend, qD[4], Xr, Yr;
   ReaL_4 TmpD, MinD, CLen, Xx, Yy;
   ReaL_4 Hwv, NHwv, Wv;
   ByTe_4  Ln;
   ByTe_4  xI, yI, rI, iD, Gp;
   ByTe_4  N, TmpI, Nb;
   ByTe_4  qL[4];

   ByTe_2 Q, Qt;
   ByTe_1 New;
   ByTe_1 *bV, *qV, *cend;

   Hwv = cinfo.CDdis;
   NHwv = -Hwv;
   Wv = 2 * Hwv;

   gV = cal.z;                                  /* ptr to grid values       */
   bV = cal.bad;                                /* ptr to bad grid values   */
   Ln = cinfo.Nbors - 1;                        /* last # of neighbors indx */

   CLen =  (cinfo.ystep < cinfo.xstep) ? cinfo.ystep : cinfo.xstep;

/****************************************************************************/
/*  Loop through all the data and assemble the requested number of nearest  */
/*  neighbors to the contour mesh position being solved for.  At the same   */
/*  time keep a set of nearest neighbors in each of the 4 quadrants about   */
/*  the mesh point.  This is added to nearest neighbors in end if not       */
/*  already included.  This should be an option but is not at present. It   */
/*  ensures that contributions if available from all sides are included in  */
/*  the fit.                                                                */
/****************************************************************************/
   
   Gp = 0;                                      /* zero Grid                */
   X = cal.X;                                   /* minimum X mesh value     */
   Xend = X + cinfo.nc;                         /* last X grid point        */
   Yend = cal.Y + cinfo.nr;                     /* last Y grid point        */
   for ( ; X < Xend; ++X) {                     /* BEG MESH COLUMN LOOP     */
      Y = cal.Y;                                /* minimum X mesh value     */
      for ( ; Y < Yend; ++Y) {                  /* BEGIN MESH ROW LOOP      */
         if (*bV == 2) {                        /* BEG MESH HAS VALUE       */
            ++gV;                               /* next mesh point          */
            ++bV;                               /* next mesh status value   */
            continue;                           /* try again                */
         }                                      /* END MESH HAS VALUE       */

         Qt = MeshEdge (Gp++);                  /* determine if mesh edge   */
         lend = qL + 4;                         /* end of quad dis array    */
         for (l1 = qL; l1 < lend; )             /* loop over quad dis array */
             *l1++ = -1;                        /* quad distance to max     */

         fend = cal.d + cinfo.Nbors;            /* end of near neigbors dis */
         for (f1 = cal.d; f1 < fend; )          /* loop over near neigh dis */
             *f1++ = 1.0e30;                    /* distance to max          */

         Nb = 0;                                /* good points found        */
         qV = cal.dQ;                           /* ptr to data quality      */

   L = iD - Level * cinfo.Y;                    /* point left of center     */
   while (L < 0) {                              /* BEG FALL OFF MESH LEFT   */
      L += cinfo.gridsize;                      /* wrap around              */
      off_left = 1;                             /* set off left flag        */
   }                                            /* END FALL OFF MESH LEFT   */

   EnD = iD + Level;                            /* absolute top row         */
   for (T = iD + 1; T <= EnD; ++T)              /* row loop                 */
      if (T % cinfo.Y == 0) {                   /* BEG BEYOND TOP OF MESH   */
         T -= 1;                                /* top of mesh              */
         break;                                 /* check is done            */
      }                                         /* END BEYOND TOP OF MESH   */

   UpLeft = L + T - iD;                         /* top left corner          */

   EnD = iD - Level;                            /* absolute bottom row      */
   for (B = iD - 1; B >= EnD; --T)              /* row loop                 */
      if (B % cinfo.Y == 0) {                   /* BEG BEYOND BOT OF MESH   */
         B += 1;                                /* top of mesh              */
         break;                                 /* check is done            */
      }                                         /* END BEYOND BOT OF MESH   */

   LowLeft = L - B - iD;                        /* bottom left corner       */


         for (iD = 0; iD < cinfo.N; ++iD)       /* loop over data           */ 
         {
            if (*qV++ == 0)
               continue;

            Xx = *(x + iD / cinfo.nr);          /* data x value             */
            Yy = *(y + iD % cinfo.nr);          /* data y value             */
            Xr = DisCycTest (Xx, *X, Hwv, NHwv, Wv); /* relative X pos      */
            Yr = Yy - *Y;                       /* relative y position      */
            MinD = Xr * Xr + Yr * Yr;           /* relative dis to mesh pt  */
            if (MinD > cinfo.MinR)              /* distance acceptable?     */
               continue;                        /* no - go to next point    */

            xI = (Xr >= 0.0) ? 0 : 1;           /* x quadrant id            */
            yI = (Yr >= 0.0) ? 0 : 2;           /* y quadrant id            */
            rI = xI + yI;                       /* quadrant data is in      */

            FillQuad (qD, qL, iD, rI, MinD, CLen);

            if (MinD < *(cal.d + Ln))           /* dis is 1 of smallest?    */
            {                                   /* yes!                     */
               ++Nb;                            /* inc possible points      */
               *(cal.d + Ln) = MinD;            /* put in last cal pos      */
               *(cal.id + Ln) = iD;             /* position of this dis     */
               f3 = cal.d;                      /* saved distances          */
               l1 = cal.id;                     /* saved data positions     */
               lend = l1 + Ln;                  /* end of saved distances   */ 
               for ( ; l1 < lend; ++f3, ++l1)   /* loop over saved dist's   */
               {
                  if ( *f3  > *(cal.d + Ln))    /* this greater than last?  */
                  {                             /* yes - swap them          */
                     TmpD = *f3;                /* current dis to temp      */
                     *f3 = *(cal.d + Ln);       /* last to current          */
                     *(cal.d + Ln) = TmpD;      /* current to last          */
                     TmpI = *l1;                /* current pos to temp      */
                     *l1 = *(cal.id + Ln);      /* last to current          */
                     *(cal.id + Ln) = TmpI;     /* current to last          */
                  }
               }
            }
         }
