#include "cont_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: Grid2DValue.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

ReaL_4 Grid2DValue (ByTe_4 N, ByTe_1 *bad)
{

   extern struct cont_info cinfo;
   extern struct cont_disp cdisp;
   extern struct cont_alloc cal;
   register ReaL_4 *f1, *fend;
   ReaL_4  Mx, Gval, Range;
   ByTe_4 Msize;

   Msize = cinfo.rank * cinfo.rank;

   Build2DMatrix (N);

   Gval = GaussJordan (cal.Mat, cal.Velem, cinfo.rank);

   f1 = cal.Mv;
   fend = cal.Mv + N;
   Mx = *f1++;
   for ( ; f1 < fend; ++f1)
      if (Mx < *f1)
         Mx = *f1;

   if (cdisp.Cs == 1)
   {
      if ((Gval - Mx) > 1.0)
         Gval = Mx;
   }
   else
   {
      if (Gval > Mx)
      {
         Range = cdisp.colmax - cdisp.colmin;
         if ((Gval > Mx) && (Gval - Mx)/Range > .1)
            Gval = Mx;
      }
   }

   return (Gval);
}
