#include "cont_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: GetPhantomCell.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

/*****************************************************************************/
/*  This routine returns the best data cell when the mesh point is just      */
/*  outside of the edge of the data array                                    */
/*                                                                           */
/*                     Q[3] ... Q[2] ... Q[1]                                */
/*                      .        .        .                                  */
/*                      .    1   .    0   .                                  */
/*                      .        .        .                                  */
/*                     Q[4] .... C  .... Q[0]                                */
/*                      .        .        .                                  */
/*                      .    2   .    3   .                                  */
/*                      .        .        .                                  */
/*                     Q[5] ... Q[6] ... Q[7]                                */
/*                                                                           */
/*  The cell numbers run from 0 to 3 and are shown above.  The input P       */
/*  indicates where the center value falls in the mesh.                      */
/*****************************************************************************/

ByTe_1 GetPhantomCell (ByTe_1 P, ReaL_4 *x, ReaL_4 *y, ReaL_4 *Rc, ReaL_4 *Rm, 
                     ByTe_4 *Q)
{
   ByTe_1 S;

   switch (P)                                           /* switch by loc of  */
   {                                                    /* of center point   */
      case 0:                                           /* interior to mesh  */
         S = -1;                                        /* nothing we can do */
      break;
      case 1:                                           /* on right edge     */
         S = (Betwixt (Rc[1], y[Q[6]], Rc[1])) ? 2 : 1; /* 1 of these cells  */
      break;
      case 2:                                           /* upper r-h corner  */
         S = 2;                                         /* only choice       */
      break;
      case 3:                                           /* on upper edge     */
         S = (Betwixt (Rc[0], x[Q[4]], Rc[0])) ? 2 : 3; /* 1 of these cells  */
      break;
      case 4:                                           /* upper l-h corner  */
         S = 3;                                         /* only choice       */
      break;
      case 5:                                           /* on left edge      */
         S = (Betwixt (Rc[1], y[Q[6]], Rc[1])) ? 3 : 0; /* 1 of these cells  */
      break;
      case 6:                                           /* lower l-h corner  */
         S = 0;                                         /* only choice       */
      break;
      case 7:                                           /* on lower edge     */
         S = (Betwixt (Rc[0], x[Q[4]], Rc[0])) ? 1 : 0; /* 1 of these cells  */
      break;
      case 8:                                           /* lower r-h corner  */
         S = 1;                                         /* only choice       */
      break;
      default:                                          /* interior to mesh  */
         S = -1;                                        /* nothing we can do */
      break;
   }
   return (S);                                          /* return cell       */
}
