/***************************************************************************
 *                                                                         *
 *                          GAUSS JORDAN SOLVER                            *
 *                                                                         *
 *  purpose                                                                *
 *    solve a system of N linear equations                                 *
 *                                                                         *
 *  usage                                                                  *
 *    ReaL_8 GaussJordan();                                                *
 *    Value = GaussJordan (mat, norder);                                   *
 *                                                                         *
 *  parameter description                                                  *
 *    float mat     matrix from which determinent is to be computed        *
 *    short norder  order of determinent (degree of matrix)                *
 *                                                                         *
 *  subprograms called                                                     *
 *    none                                                                 *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "gph_ansi.h"

ReaL_8 GaussJordan (ReaL_8 *Matrix, ReaL_8 *Solutions, ByTe_4 Rank)
{
   register ReaL_8 *d1, *d2, *d3;
   register ByTe_4 I, J, K;
   ReaL_8   Base, Pivot;
   ByTe_4   B, EnD, EnD1;
   void    *GJ;

   B = sizeof (ReaL_8) * (Rank * Rank + Rank); 
   if ((GJ = malloc(B)) == 0) {                      /* BEG MALLOC          */
      printf("\nGaussJordan - MALLOC ERROR\n");      /* error - print it    */
      exit (-1);                                     /* split               */
   }                                                 /* END MALLOC          */

   d1 = (ReaL_8 *)GJ;
   d2 = Matrix;
   d3 = Solutions;

   for (I = 0; I < Rank; ++I) {
      for (J = 0; J < Rank; ++J)
         *d1++ = *d2++; 
      *d1++ = *d3++;
   }

   EnD = Rank + 1;
   EnD1 = EnD + 1;
   for (I = 0; I < Rank; ++I) { 
      d1 = (ReaL_8 *)GJ + I * EnD1;
      Pivot = *d1;
      if (Pivot == 0.0) return (1.0e36);
      for (J = I; J < EnD; ++J) 
         *d1++ /= Pivot;

      for (J = 0; J < Rank; ++J) {
         if (J == I) continue;
         d1 = (ReaL_8 *)GJ + I * EnD1;
         d2 = (ReaL_8 *)GJ + J * EnD + I;
         Base = *d2;
         for (K = I; K < EnD; ++K, ++d1, ++d2) 
            *d2 = *d2 - Base * *d1;
      }
   }

   d1 = (ReaL_8 *)GJ;
   Base = *(d1 + Rank);
   free (GJ);
   return (Base);
}
