#include "cont_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: GatherAllNcyc.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 GatherAllNcyc (ReaL_4 *v, ReaL_4 *x, ReaL_4 *y, ReaL_4 *z, ReaL_4 Xm, 
                     ReaL_4 Ym, ReaL_4 Zm, ByTe_4 C)
{
   extern struct cont_info cinfo;
   extern struct cont_alloc cal;
   register ReaL_4 *f1, *f2, *f3, *f4, *f5, *fend;
   register ByTe_1  *c1;
   ReaL_4 *f6, *f7, *f8;
   ReaL_4 D;
   ReaL_4 dx, dy;
   ByTe_4  N = 0;


/*****************************************************************************/
/*  If not 3D then do this to pick up the data to be used in the least       */
/*  squares fit.                                                             */
/*****************************************************************************/

   if (!cinfo.three_d)
   {
      dx = x[C] - Xm;                           /* mesh pt to close pt in X  */ 
      dy = y[C] - Ym;                           /* mesh pt to close pt in Y  */
      D = dx * dx + dy * dy;                    /* mesh pt to close pt dist  */
      
      f1 = cal.Mx;                              /* ptr to relative X pos's   */
      f2 = cal.My;                              /* ptr to relative Y pos's   */
      f3 = cal.Mv;                              /* ptr to intensities        */
      f4 = x;                                   /* ptr to x data pos's       */
      f5 = y;                                   /* ptr to y data pos's       */
      f6 = v;                                   /* ptr to intensities        */
      f7 = cal.d;                               /* ptr to dis's from mesh    */
      f8 = cal.weight;                          /* ptr to weigthing          */
      c1 = cal.dQ;                              /* ptr to data quality       */
      fend = f4 + cinfo.N;                      /* last data point           */
      for ( ; f4 < fend; ++f1, ++f2, ++f3, 
                  ++f4, ++f5, ++f6, ++f7, ++f8) /* loop over data            */ 
      {
         if (*c1++ > 0)                         /* is data good?             */
         {                                      /* data is good              */
            *f1 = *f4 - Xm;                     /* relative x pos of data    */
            *f2 = *f5 - Ym;                     /* relative y pos of data    */
            *f3 = *f6;                          /* intensity                 */
            *f7 = *f1 * *f1 + *f2 * *f2;        /* distance to grid          */
            *f8 = get_wgt (D / *f7);            /* compute weighting         */
            ++N;
         }
      }
   }
   return (N);
}
