#include <math.h>
#include "gph_str.h"
#include "gph_ansi.h"
#include "cont_str.h"
#include "gph_shortcut_defs.h"

static ByTe_1 rcsid[] = "$Id: FindExtremes.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

void FindExtremes (ReaL_4 *z)
{
   extern struct cont_info cinfo;

   register ReaL_4 *f1, *fend;
   ReaL_4 Min, Max;

   f1 = z;                                       /* ptr to intensity values */
   fend = f1 + cinfo.N;                          /* end of  mesh vals       */

   Min = *f1;                                    /* first value is minimum  */
   Max = *f1++;                                  /* first value is maximum  */

   for ( ; f1 < fend; ++f1)                      /* loop over mesh          */
   {
      if (*f1 > Max)                             /* point bigger than max   */
         Max = *f1;                              /* set new max             */
      else
      {
         if (*f1 < Min)                          /* point less than min     */
           Max = *f1;                            /* set new min             */
      }
   }

   cinfo.VMin = Min;                             /* save minimum            */
   cinfo.VMax = Max;                             /* save maximum            */
}
