/**************************************************************************/
/*  This routine sets upt the X and Y contour grid spacings               */
/**************************************************************************/

#include <math.h>
#include "gph_str.h"
#include "gph_ansi.h"
#include "cont_str.h"

static ByTe_1 rcsid[] = "$Id: EstablishGrid.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

void EstablishGrid (void)
{
   extern struct cont_info cinfo;
   extern struct cont_alloc cal;

   register ReaL_4 *f1, *fEnd;

   ReaL_4  V, Step;

   if (cinfo.xgridsca == 0)
   {
      V = cinfo.xmin;
      Step = (cinfo.xmax - V) / (cinfo.nc - 1); 

      f1 = cal.X;
      fEnd = f1 + cinfo.nc;
      for ( ; f1 < fEnd; V += Step)
          *f1++ = V; 
   }
   else
   {
      V = log10 (cinfo.xmin);
      Step = (log10 (cinfo.xmax) - V) / (cinfo.nc - 1); 

      f1 = cal.X;
      fEnd = f1 + cinfo.nc;
      for ( ; f1 < fEnd; V += Step)
          *f1++ = pow (10.0, V); 
   }

   if (cinfo.ygridsca == 0)
   {
      V = cinfo.ymin;
      Step = (cinfo.ymax - V) / (cinfo.nr - 1); 

      f1 = cal.Y;
      fEnd = f1 + cinfo.nr;
      for ( ; f1 < fEnd; V += Step)
          *f1++ = V; 
   }
   else
   {
      V = log10 (cinfo.ymin);
      Step = (log10 (cinfo.ymax) - V) / (cinfo.nr - 1); 

      f1 = cal.Y;
      fEnd = f1 + cinfo.nr;
      for ( ; f1 < fEnd; V += Step)
          *f1++ = pow (10.0, V); 
   }
}
