#include "gph_str.h"
#include "gph_ansi.h"
#include "cont_str.h"
#include "gph_shortcut_defs.h"
#include <string.h>

static ByTe_1 rcsid[] = "$Id: DisplayMesh.c,v 1.1 1999/11/21 08:39:30 chris.gurgiolo.b2r Stab chrisg $";

void DisplayMesh (ByTe_1 wn)
{
   extern struct cont_disp cdisp;
   extern struct cont_info cinfo;
   extern struct cont_alloc cal;

   register ReaL_4 *X, *Y, *Xend, *Yend;
   register ReaL_4 *f1;
   register ByTe_1  *c1;

   ReaL_4 Fc;
   ByTe_2 C;

   if (cdisp.show_grid == 0)
      return;

   X = cal.X;                                   /* minimum X mesh value     */
   Xend = X + cinfo.nc;                         /* last X grid point        */
   Yend = cal.Y + cinfo.nr;                     /* last Y grid point        */

   if (cdisp.grid_color >= 0)                   /* monotone?          */
   {
      C = cdisp.grid_color;                     /* this color         */
      for ( ; X < Xend; ++X)                    /* loop over mesh columns   */
      {                                         /* BEG MESH COLUMN LOOP     */
         Y = cal.Y;                             /* minimum X mesh value     */
         for ( ; Y < Yend; ++Y)                 /* loop over mesh columns   */
            CTEXT (wn, *X, *Y, "+", C);         /* display it         */
      } 
   }
   else
   {

      f1 = cal.z;                                     /* grid values        */
      c1 = cal.bad;
      for ( ; X < Xend; ++X)                    /* loop over mesh columns   */
      {                                         /* BEG MESH COLUMN LOOP     */
         Y = cal.Y;                             /* minimum X mesh value     */
         for ( ; Y < Yend; ++Y)                 /* loop over mesh columns   */
         {
            Fc = cdisp.Xcol[1] + cdisp.Xcol[0] * *f1++;   /* floating color */
            if (Fc > cdisp.Xcol[2])                   /* greater than max?  */
               C = cdisp.Xcol[2];                     /* set to max         */
            else
               C = (Fc < cdisp.Xcol[3]) ? 0 : Fc;      /* set color          */

            if (C > 0 && *c1++ == 0)                   /* Color not black?   */
                CTEXT (wn, *X, *Y, "+", C);            /* display mesh pt    */
         }
      } 
   }
}
