#include "gph_str.h"
#include "gph_ansi.h"
#include "cont_str.h"
#include "gph_shortcut_defs.h"
#include <string.h>

static ByTe_1 rcsid[] = "$Id: DisplayData.c,v 1.1 1999/11/21 08:39:30 chris.gurgiolo.b2r Stab chrisg $";

void DisplayData (ByTe_1 wn, ReaL_4 *v, ReaL_4 *x, ReaL_4 *y, ReaL_4 *z, 
                  ByTe_4 N)
{
   extern struct cont_info cinfo;
   extern struct cont_disp cdisp;
   extern struct cont_alloc cal;

   register ReaL_4 *f1;
   register ByTe_4 L;
   register ByTe_1  *c1;

   ReaL_4 Fc, X, Y;
   ByTe_4 len, Xwrap, Ywrap;
   ByTe_2 C;
   ByTe_1 str[20];

   len = strlen (cdisp.sh_dat_fmt);                    /* Show data if appl. */
   if (cinfo.data_type == 3)                           /* hollow grid?       */
   {
      Xwrap = cinfo.nr;
      Ywrap = cinfo.nr;
   } else {
      Xwrap = 1;
      Ywrap = 2 * N;
   }

   if (len > 0)                                        /* need to show data? */
   {                                                   /* yes!               */
      chr_size (15);                                   /* set text size      */
      f1 = v;                                          /* ptr to values      */
      c1 = cal.dQ;                                     /* ptr to data qual   */
      if (len == 1)                                    /* single character?  */
      {                                                /* yes!               */
         sprintf(str, "%s", cdisp.sh_dat_fmt);         /* put in string      */
         if (cdisp.data_color >= 0)                    /* monotone?          */
         {                                             /* yes                */
            C = cdisp.data_color;                      /* this color         */
            for (L = 0; L < N; ++L)                    /* loop over data     */
            {
/*
               if (*c1++ == 1)
               {
*/
                  X = *(x + L / Xwrap);                /* data x value       */
                  Y = *(y + L % Ywrap);                /* data y value       */
                  CTEXT (wn, X, Y, str, C);            /* print  data        */
/*
               }
*/
            }
         } else {
            for (L = 0; L < N; ++f1, ++L)              /* loop over data     */
            {
               if (*c1++ == 1)                         /* data qual ok?      */
               {
                  Fc = cdisp.Xcol[1] + cdisp.Xcol[0] * *f1; /* float color   */
                  if (Fc > cdisp.Xcol[2])              /* greater than max?  */
                     C = cdisp.Xcol[2];                /* set to max         */
                  else
                     C = (Fc < cdisp.Xcol[3]) ? 0 : Fc;   /* set color       */

                  if (C > 0)                           /* Color not black?   */
                  {
                     X = *(x + L / Xwrap);             /* data x value       */
                     Y = *(y + L % Ywrap);             /* data y value       */
                     CTEXT (wn, X, Y, str, C);         /* print  data        */
                  }
               }
            }
         }
      } else {
         if (cdisp.data_color >= 0)                    /* monotone?          */
         {
            C = cdisp.data_color;                      /* this color         */
            for (L = 0; L < N; ++L)                    /* loop over data     */
            {
               sprintf(str, cdisp.sh_dat_fmt, *f1++);  /* data val to str    */
               X = *(x + L / Xwrap);                   /* data x value       */
               Y = *(y + L % Ywrap);                   /* data y value       */
               if (*c1++ == 1)                         /* data qual ok?      */
                  CTEXT (wn, X, Y, str, C);            /* print  data        */
            }
         } else {
            for (L = 0; L < N; ++L)                    /* loop over data     */
            {
               Fc = cdisp.Xcol[1] + cdisp.Xcol[0] * *f1; /* floating color   */
               if (Fc > cdisp.Xcol[2])                 /* greater than max?  */
                  C = cdisp.Xcol[2];                   /* set to max         */
               else
                  C = (Fc < cdisp.Xcol[3]) ? 0 : Fc;   /* set color          */
               sprintf(str, cdisp.sh_dat_fmt, *f1++);  /* data val to str    */
               X = *(x + L / Xwrap);                   /* data x value       */
               Y = *(y + L % Ywrap);                   /* data y value       */
               if (C > 0 && *c1++ == 1)                /* Color not black?   */
                  CTEXT (wn, X, Y, str, C);            /* print  data        */
            }
         }
      }
         
      chr_size (10);                                   /* return text size   */
   }
}
