#include "cont_str.h"
#include "gph_ansi.h"
#include <math.h>

static ByTe_1 rcsid[] = "$Id: Cut1D.c,v 1.1 1999/11/21 08:39:30 chris.gurgiolo.b2r Stab chrisg $";

ReaL_4 Cut1D(ReaL_4 *x, ReaL_4 *y, ReaL_4 *z, ReaL_4 *r, ReaL_4 x1, ReaL_4 y1,
                ReaL_4 x2, ReaL_4 y2, ByTe_4 N)
{
   extern struct cont_info cinfo;
   extern struct cont_alloc cal;

   register ReaL_4 *f1, *f2, *f3, *f4, *f5, *fend;
   register ByTe_1 *c1;
   register ByTe_4 i;

   ReaL_4 Lc, Rc, Tr, Br, BaseLen;
   ReaL_4 Tz, Bz, BiG;
   ReaL_4 dX,dY, Slope, Slope2;
   ReaL_4 X, Y, XMn, XMx, XSt, YMn, YMx, YSt;
   ReaL_4 Lx, Ly, Ux, Uy;
   ReaL_4 Len;

   ByTe_4 P[6];
   ByTe_4 Nr;

   ByTe_2 Sx,Sy;
   ByTe_1 BaD;
   
   if (cinfo.xgridsca == 0) {                        /* BEG X GRIDDED LINEAR */
      XMn = cinfo.xmin;                              /* min x mesh valaue    */
      XMx = cinfo.xmax;                              /* max x mesh value     */
   } else {                                          /* BEG X GRIDDED LOG    */
      XMn = log10(cinfo.xmin);                       /* min x mesh valaue    */
      XMx = log10(cinfo.xmax);                       /* max x mesh value     */
   }                                                 /* END X GRID CHECK     */
   XSt = (XMx - XMn) / (cinfo.nc - 1);               /* mesh x deltas        */

   if (cinfo.ygridsca == 0) {                        /* BEG Y GRIDDED LINEAR */
      YMn = cinfo.ymin;                              /* min y mesh valaue    */
      YMx = cinfo.ymax;                              /* max y mesh value     */
   } else {                                          /* BEG Y GRIDDED LOG    */
      YMn = log10(cinfo.ymin);                       /* min y mesh valaue    */
      YMx = log10(cinfo.ymax);                       /* max y mesh value     */
   }                                                 /* END Y GRID CHECK     */
   YSt = (YMx - YMn) / (cinfo.nr - 1);               /* mesh x deltas        */

   if (XSt < 0.0) {                                  /* BEG REVERSED X       */
      Lx = XMx;                                      /* min is max           */
      Ux = XMn;                                      /* max is min           */
   } else {                                          /* BEG NORMAL X         */
      Lx = XMn;                                      /* min is min           */
      Ux = XMx;                                      /* max is max           */
   }                                                 /* END X REARRANGEMENT  */

   if (YSt < 0.0) {                                  /* BEG REVERSED Y       */
      Ly = YMx;                                      /* min is max           */
      Uy = YMn;                                      /* max is min           */
   } else {                                          /* BEG NORMAL Y         */
      Ly = YMn;                                      /* min is min           */
      Uy = YMx;                                      /* max is max           */
   }                                                 /* END Y REARRANGEMENT  */

   Nr  = cinfo.nr;                                   /* rows in mesh         */
   f1 = cal.z;                                       /* ptr to contour mesh  */
   c1 = cal.bad;                                     /* mesh status          */
   fend = f1 + cinfo.gridsize;                       /* last pnt in mesh     */
   do {                                              /* BEG TO 1ST GOOD PNT  */
      if (*c1 == 0)                                  /* good mesh value?     */
         BiG = *f1;                                  /* initialize BiG       */
      ++f1;                                          /* next data point      */
   } while (*c1++ == 1 && f1< fend);                 /* END TO 1ST GOOD PNT  */

   for ( ; f1 < fend; ++f1, ++c1)                    /* loop over mesh       */
      if (*f1 > BiG && *c1 == 0)                     /* this point bigger?   */
         BiG = *f1;                                  /* new biggest point    */

   BiG = floor (BiG);                                /* drop decimal part    */

   if (BiG == 0.0)                                   /* is huge zero?        */
      BiG = 10.0;                                    /* yes - set to 10.0    */
   else
      BiG *= (BiG < 0) ? -10.0 : 10.0;               /* huge bigger than big */

   dX = x2 - x1;                                     /* run in cut           */
   dY = y2 - y1;                                     /* rise in cut          */

   Sx = (dX >= 0.0) ? 1 : -1;                        /* set x sign by run    */
   Sy = (dY >= 0.0) ? 1 : -1;                        /* set y sign by run    */

   if (dX != 0)                                      /* cut parallel to y?   */
   {                                                 /* no!                  */
      Slope = dY/dX;                                 /* compute slope        */
      Slope2 = sqrt(Slope * Slope + 1.0);            /* needed constant      */
   }

   BaseLen = sqrt(dX * dX + dY * dY) / N;            /* len between out_data */
 
   f1 = x;                                           /* ptr to output x val  */
   f2 = y;                                           /* ptr to output y val  */
   f3 = z;                                           /* ptr to output z val  */
   f4 = r;                                           /* ptr to radius        */
   f5 = cal.z;                                       /* ptr to mesh values   */
   c1 = cal.bad;                                     /* ptr to mesh status   */
   fend = f1 + N;                                    /* end of pts along cut */
   Len = BaseLen;                                    /* Len along cut        */
   for ( ; f1 < fend; ++f1, ++f2, ++f4)              /* loop over ret data   */
   {
      *f4 = Len;                                   
      if (dX == 0) {                                 /* BEG PARALLEL TO Y    */
         *f1 = 0.0;                                  /* x pos for value      */
         *f2 = *f4 * Sy + y1;                        /* y pos for value      */
      } else {                                       /* BEG NOTHING SPECIAL  */
         *f1 = *f4 * Sx / Slope2;                    /* x pos for value      */
         *f2 = *f1 * Slope + y1;                     /* y position for value */
      }                                              /* END X,Y COORDINATES  */

      *f1 += x1;                                     /* final X position     */

      X = (cinfo.xgridsca == 0) ? *f1 : log10(*f1);
      Y = (cinfo.ygridsca == 0) ? *f2 : log10(*f2);
      if ((X < Lx || X > Ux) || (Y < Ly || Y > Uy))  /* out of mesh?         */
      {                                              /* yes;                 */
         *f3++ = BiG;                                /* set value to BiG     */
         Len += BaseLen;
         continue;                                   /* set up next point    */
      }

      Lc = floor ((X - XMn) / XSt);                  /* left column number   */
      Rc = Lc + 1.0;                                 /* right column number  */
      
      Br = floor ((Y - YMn) / YSt);                  /* lower row number     */
      Tr = Br + 1.0;                                 /* upper row number     */

      P[0] = (ByTe_4)(Lc * Nr + Tr + 0.001);         /* upper left corner    */
      P[1] = (ByTe_4)(Lc * Nr + Br + 0.001);         /* lower left corner    */
      P[2] = (ByTe_4)(Rc * Nr + Br + 0.001);         /* lower right corner   */
      P[3] = (ByTe_4)(Rc * Nr + Tr + 0.001);         /* upper left corner    */
      P[4] = P[0];                                   /* upper left corner    */
      P[5] = P[1];                                   /* lower left corner    */

/****************************************************************************/
/*  Loop over the positions and if the point is bad assign to that point    */
/*  the average of the two nearest corners                                  */
/****************************************************************************/

      i = 1;
      BaD = 0;
      while (BaD <= 1 && i < 5)
      {
         if (*(c1 + P[i++]))
         {
            ++BaD;
            *(f5 + P[i-1]) = (*(f5 + P[i-2]) + *(f5 + P[i]))/2.0; 
         }
      }
      
      if (BaD <= 1)
      {
         Tz = (X - (Lc * XSt + XMn)) / XSt;
         Bz = Tz * (*(f5 + P[2]) - *(f5 + P[1])) + *(f5 + P[1]);
         Tz = Tz * (*(f5 + P[3]) - *(f5 + P[0])) + *(f5 + P[0]);
         *f3++ = (Y - (Br * YSt + YMn)) / YSt * (Tz - Bz) + Bz;
      }
      else
         *f3++ = BiG;

      Len += BaseLen;
   }

   return(BiG);
}
