#include "gph_str.h"
#include "gph_ansi.h"
#include "cont_str.h"

static ByTe_1 rcsid[] = "$Id: ColorInGrid.c,v 1.1 1999/11/21 08:39:30 chris.gurgiolo.b2r Stab chrisg $";

void ColorInGrid( )
{
   extern struct cont_disp cdisp;
   extern struct config parm;
   extern struct cont_info cinfo;
   extern struct cont_alloc cal;
   register ReaL_4 *X, *Y;
   register ByTe_4 Col, Row;
   register ByTe_4 I, J;
   ByTe_2 C, jend,jstart,inc;
   ReaL_4 llz,ulz,lrz,urz;
   ReaL_4 sm, x1, x2;
   ReaL_4 R[8], T[4], Last, dX;
   ReaL_4 r[4];
   ByTe_4 EndX, EndY, NextCol;
   ByTe_1 test, wn, LaC;

   wn = cdisp.window;                            /* contour window number */

/**************************************************************************/
/*  Set sm to the smoothing used in painting each contour grid cell.      */
/*  cell is subdivided into sm x sm subcell and each assigned a color     */
/*  based on the colors set at each cornor of the main cell.              */
/**************************************************************************/

   sm = cdisp.smooth;                          /* set cell smoothing      */
   
/**************************************************************************/
/*  Begin looping over the grid cells.  The cell arrangement is shown in  */
/*  the diagram below                                                     */
/*                                                                        */
/*                   .     .     .     .     .                            */
/*                                                                        */
/*               ^   .     .     .     .     .                            */
/*               |                                                        */
/*                   .     .     .     .     .                            */
/*               r                                                        */
/*               o   .     .     .     .     .                            */
/*               w                                                        */
/*               s   .     .     .     .     .                            */
/*                                                                        */
/*                   .     .     .     .     .                            */
/*                                                                        */
/*                           columns ->                                   */
/*                                                                        */
/*  The data is stored in a linear array of size cinfo.nr x cinfo.nc.     */
/*  The data is laid down column by column, with the left most column     */
/*  being the first laid down.  The first value is the lower left-hand    */
/*  value.                                                                */
/*                                                                        */
/*  Any grid position (R,C) is found in the array through the formula     */
/*                                                                        */
/*                        POS = (cinfo.nr * C) + R                        */
/*                                                                        */
/*  If this is a cyclic plot remember to double back at the last          */
/**************************************************************************/

   X = (ReaL_4 *) cal.X;                        /* x grid position        */
   EndX = cinfo.nc - 1;                         /* last x loop position   */
   Last = cinfo.nc - 1;                         /* last x position        */
   EndY = cinfo.nr - 1;                         /* last y loop position   */
   if (cinfo.cyclic > 0)                        /* cyclic plot?           */
      ++EndX;                                   /* add cyclic column      */

   for (Col = 0 ; Col < EndX ; ++Col, ++X)      /* loop over columns      */
   {
      r[0] = *X;                                /* x pos of low-left cor  */ 
      if (cinfo.cyclic == 1 && Col == Last)     /* cyclic and last        */
      {
         LaC = 1;                               /* last and cyclic        */
         x1 = cinfo.MaxCD - *X;
         x2 = *(ReaL_4*)cal.X - cinfo.MinCD;
         dX = cinfo.MaxCD - cinfo.MinCD;
         r[2] = (x1 + x2) / sm;
         if (r[2] == 0.0)
            continue;
      }
      else
      {
         LaC = 0;                               /* last and cyclic        */
         r[2] = (*(X+1) - *X)/ sm;              /* x dis between subcells */
      }

      Y = (ReaL_4 *) cal.Y;                     /* y grid position        */
      for (Row = 0 ; Row < EndY; ++Row, ++Y)    /* loop over rows         */
      {
         NextCol = (Col + 1) % cinfo.nc;        /* next column            */ 
         I = Col * cinfo.nr + Row;              /* index to llh grid val  */
         J = NextCol * cinfo.nr + Row;          /* index to lrh grid val  */
         r[1] = *Y;                             /* y-pos of low-left cor  */
         r[3] = (*(Y+1) - *Y)/ sm;              /* x dis between subcells */
         test = 0;                              

         lrz = *(cal.z + J);                    /* lower-right grid value */
         urz = *(cal.z + J + 1);                /* upper-right grid value */
         llz = *(cal.z + I);                    /* lower-left grid value  */
         ulz = *(cal.z + I + 1);                /* upper-left grid value  */

/**************************************************************************/
/*  Smoothing.  A given grid is smoothed in the following manner and is   */
/*  illustrated below.   The grid corners are marked by v's and the       */
/*  subcell being colored is marked with an X.                            */
/*                                                                        */
/*                                 A    B                                 */
/*                     v  _  .  _  .  _  .  _  v                          */
/*                                                                        */
/*                     |     |     |     |     |                          */
/*                     .  _  .  _  .  _  .  _  .                          */
/*                                                                        */
/*                     |     |     |     |     |                          */
/*                     .  _  .  _  a  _  b  _  .                          */
/*                                                                        */
/*                     |     |     |  X  |     |                          */
/*                     .  _  .  _  c  _  d  _  .                          */
/*                                                                        */
/*                     |     |     |     |     |                          */
/*                     v  _  .  _  .  _  .  _  v                          */
/*                                                                        */
/*                                 C     D                                */
/*                                                                        */
/*  First, a linear interpolation in color is made along the top and      */
/*  bottom of the grid to give color values at the projection of the      */
/*  subcell corners (A, B, C, and D).  Then as set of linear              */
/*  interpolations in color is made between A-C and B-D to give color     */
/*  values at the subcell corners (a, b, c, and d).  The color assigned   */
/*  to the subcell is the average color of its corners.                   */
/*                                                                        */
/*  If two or more of the grid corners have unusable (bad) values then    */
/*  all of the grid subcells are left black.  If, however only one of the */
/*  grid corners has a bad value associated with it, then half the        */
/*  subcells will be filled as shown below.  In each example the unusable */
/*  grid corner is labeled by an x,  the grid corners with valid values   */
/*  are labeled V, each subcell is demarked by  a "." and  the colored    */
/*  subgrids have a C in their center                                     */
/*                                                                        */
/*               CASE 1                          CASE 2                   */
/*                                                                        */
/*     v  _  .  _  .  _  .  _  v        x  _  .  _  .  _  .  _  v         */
/*                                                                        */
/*     |  C  |  C  |  C  |  C  |        |     |     |     |  C  |         */
/*     .  _  .  _  .  _  .  _  .        .  _  .  _  .  _  .  _  .         */
/*                                                                        */
/*     |     |  C  |  C  |  C  |        |     |     |  C  |  C  |         */
/*     .  _  .  _  .  _  .  _  .        .  _  .  _  .  _  .  _  .         */
/*                                                                        */
/*     |     |     |  C  |  C  |        |     |  C  |  C  |  C  |         */
/*     .  _  .  _  .  _  .  _  .        .  _  .  _  .  _  .  _  .         */
/*                                                                        */
/*     |     |     |     |  C  |        |  C  |  C  |  C  |  C  |         */
/*     x  _  .  _  .  _  .  _  v        v  _  .  _  .  _  .  _  v         */
/*                                                                        */
/*                                                                        */
/*               CASE 3                          CASE 4                   */
/*                                                                        */
/*     v  _  .  _  .  _  .  _  v        v  _  .  _  .  _  .  _  x         */
/*                                                                        */
/*     |  C  |  C  |  C  |  C  |        |  C  |     |     |     |         */
/*     .  _  .  _  .  _  .  _  .        .  _  .  _  .  _  .  _  .         */
/*                                                                        */
/*     |  C  |  C  |  C  |     |        |  C  |  C  |     |     |         */
/*     .  _  .  _  .  _  .  _  .        .  _  .  _  .  _  .  _  .         */
/*                                                                        */
/*     |  C  |  C  |     |     |        |  C  |  C  |  C  |     |         */
/*     .  _  .  _  .  _  .  _  .        .  _  .  _  .  _  .  _  .         */
/*                                                                        */
/*     |  C  |     |     |     |        |  C  |  C  |  C  |  C  |         */
/*     v  _  .  _  .  _  .  _  x        v  _  .  _  .  _  .  _  v         */
/*                                                                        */
/*  Note that in each of the above cases, the bad corner is assigned the  */
/*  value and coordinates of horizontal good corner.                      */
/**************************************************************************/

/**************************************************************************/
/*  Set the scanning pattern through the subcells.  The subcells are      */
/*  scanned from right to left and from bottom to top.  Changes in the    */
/*  starting and ending cell number and how these vary from row to row    */
/*  determine the pattern of cells filled as shown above                  */
/**************************************************************************/

         if (*(cal.bad + I) == 1)               /* is low-left val ok?    */ 
         {                                      /* no!                    */
            test = 1;                           /* got a bad corner       */
            jstart = cdisp.smooth-1;            /* assign start loop val  */
            jend =  cdisp.smooth;               /* assign stop loop val   */
            inc =  -1;                          /* assign start increment */
            llz = lrz;                          /* set bad corner value   */
         }

         if (*(cal.bad + I + 1) == 1)           /* is up-left val ok      */
         {                                      /* no!                    */
            if (test == 0)                      /* previous bad val?      */
            {                                   /* no!                    */
               test = 1;                        /* got a bad corner       */
               jstart = 0;                      /* assign start loop val  */
               jend =  cdisp.smooth;            /* assign stop  loop val  */
               inc = 1;                         /* assign start increment */
               ulz = urz;                       /* set bad corner value   */
            }
            else                                /* yes, previous bad val  */
               continue;                        /* abandon grid           */
         }
        
         if (*(cal.bad + J) == 1)               /* is low-right val ok    */
         {                                      /* no!                    */
            if (test == 0)                      /* previous bad val?      */
            {                                   /* no!                    */
               test = 2;                        /* got a bad corner       */
               jstart = 0;                      /* assign start loop val  */
               jend =  1;                       /* assign stop  loop val  */
               inc = 1;                         /* assign start increment */
               lrz = llz;                       /* set bad corner value   */
            }
            else                                /* yes, previous bad val  */
               continue;                        /* abandon grid           */
         }
        
         if (*(cal.bad + J + 1) == 1)           /* is up-right val ok?    */
         {                                      /* no!                    */
            if (test == 0)                      /* previous bad val?      */
            {                                   /* no!                    */
               test = 2;                        /* got a bad corner       */
               jstart = 0;                      /* assign start loop val  */
               jend =  cdisp.smooth;            /* assign stop  loop val  */
               inc = -1;                        /* assign start increment */
               urz = ulz;                       /* set bad corner value   */
            }
            else                                /* yes, previous bad val  */
               continue;                        /* abandon grid           */
         }

         if (test == 0)                         /* are all corners ok     */
         {                                      /* yes                    */
            jstart = 0;                         /* assign start loop val  */
            jend =  cdisp.smooth;               /* assign stop  loop val  */
         }

/**************************************************************************/
/*  Begin looping over subcells                                           */
/**************************************************************************/

         for (I = 0; I < cdisp.smooth; ++I)      /* LOOP over ROWS        */ 
         {
            for (J = jstart ; J < jend ; ++J)    /* LOOP over COLUMNS     */
            {
               C = cell_color (J, I, llz, lrz, urz, ulz);

               if (C > parm.black)               /* subcell color black?   */
               {                                 /* no!                    */
                  fill (0, C);                   /* set fill               */
                  get_cell (J, I, r, R);         /* get subcell location   */
                  if (LaC)                       /* cyclic and last        */
                  {                              /* BEG LAST AND CYCLIC    */
                     if (R[0] >= cinfo.MaxCD)
                     {
                        T[0] = R[0] - dX;
                        T[3] = T[0];
                        T[1] = R[1] - dX;
                        T[2] = T[1];
                        poly (wn, T, R+4, R, 4);
                     }
                     else
                     {
                        if (R[1] > cinfo.MaxCD)
                        {
                           T[1] = R[1] - dX;
                           T[2] = T[1];
                           R[1] = cinfo.MaxCD;
                           R[2] = cinfo.MaxCD;
                           poly (wn, R, R+4, R, 4);
                           T[0] = cinfo.MinCD;
                           T[3] = cinfo.MinCD;
                           poly (wn, T, R+4, R, 4);
                        }
                        else
                           poly (wn, R, R+4, R, 4);
                     }
                  }
                  else
                     poly (wn, R, R+4, R, 4);       /* fill in subcell       */
               }
            }

            switch (test)                       /* change column scan     */
            {
               case 0:                          /* no change              */
                  break; 
               case 1:                          /* change begin position  */
                  jstart += inc;
                  break;
               case 2:
                  jend += inc;                  /* change end position    */
                  break;
            }
         }
      } 
   }

   fill (-1, -1);                               /* turn fill off          */
}
