/***************************************************************************/
/* This routine zeros out the bad data and segment arrays                  */
/***************************************************************************/

#include "gph_str.h"
#include "gph_ansi.h"
#include "cont_str.h"
#include "gph_shortcut_defs.h"

static ByTe_1 rcsid[] = "$Id: Cleanse.c,v 1.1 1999/11/21 08:39:30 chris.gurgiolo.b2r Stab chrisg $";

void Cleanse ( )
{
   extern struct cont_info cinfo;
   extern struct cont_alloc cal;

   register ByTe_1 *c1, *cend;

   cend = cal.seg + cinfo.numseg;                   /* end of segment array  */
   for (c1 = cal.seg; c1 < cend; )                  /* loop over seg array   */
      *c1++ = 0;                                    /* zero out seg array    */

   if (cinfo.data_type < 3)                         /* only for pregridded   */
   {
      c1 = cal.bad;                                 /* ptr to bad data array */
      cend = c1 + cinfo.gridsize;                   /* end of bad data array */
      for ( ; c1 < cend ; )                         /* loop over bad data    */
         *c1++ = 0;                                 /* zero it out           */
   }
}
