#include <math.h>
#include <string.h>
#include "gph_str.h"
#include "cont_str.h"
#include "gph_ansi.h"
#include "gph_opind.h"

static ByTe_1 rcsid[] = "$Id: BlankOutLab.c,v 1.1 1999/11/21 08:39:30 chris.gurgiolo.b2r Stab chrisg $";

void BlankOutLab(ReaL_4 X, ReaL_4 Y, ReaL_4 A, ByTe_1 *Str, ReaL_4 *Cz)
{
   extern struct config parm;
   extern struct cont_disp cdisp;

   ReaL_4 Xs, Ys;
   ReaL_4 dX, dY;
   ReaL_4 Ca, Sa;
   ReaL_4 Xp[4], Yp[4];

   ByTe_2 C;
   ByTe_4 Slen;
                 
   C = (cdisp.normal > parm.black) ? parm.black : parm.white;
   Slen = strlen (Str);

   Xs = Cz[0] * Slen / 2.0;
   Ys = Cz[1] / 2.0;

   Ca = cos (A * M_PI / 180.0);
   Sa = sin (A * M_PI / 180.0);

   dX = -Xs * Ca + Ys * Sa;
   dY = -Xs * Sa - Ys * Ca;
   Xp[0] = X + dX;
   Yp[0] = Y + dY;

   dX = Xs * Ca + Ys * Sa;
   dY = Xs * Sa - Ys * Ca;
   Xp[1] = X + dX;
   Yp[1] = Y + dY;

   dX = Xs * Ca - Ys * Sa;
   dY = Xs * Sa + Ys * Ca;
   Xp[2] = X + dX;
   Yp[2] = Y + dY;

   dX = -Xs * Ca - Ys * Sa;
   dY = -Xs * Sa + Ys * Ca;
   Xp[3] = X + dX;
   Yp[3] = Y + dY;

   fill (0, C);
   poly (cdisp.window, Xp, Yp, Xp, 4);
   fill (-1, -1);
}
