#include "gph_str.h"
#include "gph_ansi.h"
#include "cont_str.h"

static ByTe_1 rcsid[] = "$Id: recursive.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";
 
void recursive (ByTe_4 P1, ByTe_4 P2, ByTe_4 start)
{
   extern struct cont_disp cdisp;
   extern struct cont_info cinfo;
   extern struct cont_alloc cal;

   register ReaL_4 *z;

   ReaL_4 X,Y;

   ByTe_4 T, Sg1, Sg2;

   ByTe_1 B, B1, B2, done=0;

   ++cinfo.calls;                                 /* inc # calls to routine  */
   z = cal.z;                                     /* fast ptr to intensities */
   if ( *(z + P1) > *(z + P2) )                   /* pnt 1 > pnt 2           */
   {                                              /* yes                     */
      T = P1;
      P1 = P2;                                    /* set min point           */ 
      P2 = T;                                     /* set max point           */ 
   }

   T = get_third (P1, P2, start);                 /* get 3rd pnt in triangle */

   if (T < 0)                                     /* valid point?            */
   {                                              /* no!                     */
      interpol(P1, P2, &X, &Y);                   /* get end of contour      */
      done = 1;                                   /* set done                */
      B = 2;                                      /* set border              */
   }
   else                                           /* got a valid point       */
   {
      get_num(&Sg1, P1, T, &B1);                  /* get seg P1 and new pnt  */
      get_num(&Sg2, P2, T, &B2);                  /* get seg P2 and new pnt  */
      *(cal.seg + Sg2) = 1;                       /* set seg2 to scanned     */
    
      if (*(z + T) == cinfo.clevel)
         *(z + T) += (cinfo.finish-cinfo.begin)* 0.00001;

      if (*(z + T) > cinfo.clevel)                /* new pt > contour level */
      {                                           /* yes!                   */
         if (Sg1 == start || B1 > 0)              /* back to beg or border? */
         {
            done = 1;                             /* yes - set done         */
            if (Sg1 == start)
               cinfo.line_stat = -1;
         }
         *(cal.seg + Sg1) = 1;                    /* mark segment crossed   */
         P2 = T;                                  /* P2 to new point        */
         interpol(P1, P2, &X, &Y);                /* inc contour segment    */
         B = B1;                                  /* keep border status     */
      }
      else
      {
         if (Sg2 == start || B2 > 0)              /* back to beg or border? */
         {
            done = 1;                             /* yes - set done         */
            if (Sg2 == start)
               cinfo.line_stat = -1;
         }
         
         *(cal.seg + Sg1) = -1;                   /* mark seg1 below lev    */
         P1 = T;                                  /* P1 to new point        */
         interpol(P2, P1, &X, &Y);                /* inc contour segment    */
         B = B2;                                  /* keep border status     */
      } 
   }

   if (cinfo.calls >= cinfo.numseg - 1)
      return;

   if (!done)                                         
   {
      mv_n_drw(cdisp.window,X,Y,0.0,1,0);
      recursive (P1, P2, start);
   }
   else
   {
      if (cdisp.num_on)
         line_num();

      if (B > 0)
         mv_n_drw(cdisp.window,X,Y,0.0,1,B);
      else
         mv_n_drw(cdisp.window,X,Y,0.0,1,1);
   }
}
