#include "cont_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: interpol.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";
 
void interpol(ByTe_4 P1, ByTe_4 P2, ReaL_4 *Xc, ReaL_4 *Yc)
{
   extern struct cont_info cinfo;
   extern struct cont_alloc cal;
   register ReaL_4 *f1, *f2;
   register ReaL_8 ratio;
   ReaL_8 x1, x2, y1, y2;

   f1 = cal.z + P1;
   f2 = cal.z + P2;

   if (*f2 == *f1)
      ratio = 0.0;
   else
      ratio = (cinfo.clevel - *f1) / (*f2 - *f1);
   
   x1 = *(cal.X + (ByTe_4) (P1 / cinfo.nr) );
   y1 = *(cal.Y + (P1 % cinfo.nr) );
   x2 = *(cal.X + (ByTe_4) (P2 / cinfo.nr) );
   y2 = *(cal.Y + (P2 % cinfo.nr) );

   *Xc = x1 + ratio * (x2 - x1);
   *Yc = y1 + ratio * (y2 - y1);
}
