#include "gph_str.h"
#include "gph_ansi.h"
#include "cont_str.h"
 
/*  id1 and id2 are the two points the level came through.
    third is the third pt in the triangle whose cal.z value should 
    equal the value of the level that is currently being contoured.
    num1 and num2 are the segment numbers for the segments formed
    by id1 with third and id2 with third */  

static ByTe_1 rcsid[] = "$Id: gridxing.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

void gridxing(long id1, long id2, long third, long num1, long num2)
{
   extern struct cont_info cinfo;
   extern struct cont_alloc cal;
   float z1,z2;
   long num[6],rseg[6],bseg[6],pt1,pt2;
   short i;
   
/* GET 6 PTS AROUND POINT IN QUESTION  */

   num[0] = third+1;
   num[1] = third+cinfo.nr+1;
   num[2] = third+cinfo.nr;
   num[3] = third-1;
   num[4] = third-1-cinfo.nr;
   num[5] = third-cinfo.nr;

/* BASED ON THE LOCATION OF THE POINT, IT MAY NOT HAVE ALL SIX PTS
   AROUND IT.  IN THIS CASE, SET THE BAD PTS TO -1 */

   if ( third < cinfo.nr )  /* if pt is on left edge... */
   {
      num[4] = -1;
      num[5] = -1;
   }
   else if (third >= cinfo.nr*(cinfo.nc-1)) /* if pt is on right edge ... */
   {
      num[1] = -1;
      num[2] = -1;
   }
    
   if ((third%cinfo.nr) == 0)  /* if pt is on the bottom of the grid ... */
   {
      num[3] = -1;
      num[4] = -1;
   }
   else if (((third+1)%cinfo.nr) == 0) /* if pt is on top of grid ... */
   {
      num[0] = -1;
      num[1] = -1;
   }

/*  
   RSEG --> RADIAL SEGMENT 
   BSEG --> BORDER SEGMENT 
   
   IF THE PTS HAVE BEEN DETERMINED TO BE BAD, SET THE 
   APPROPRIATE SEGMENTS TO BE BAD (-1) ALSO.
*/
   for (i=0 ; i < 6 ; ++i)
   {
      if (num[i] < 0)
      {
         rseg[i] = -1;
         bseg[i] = -1;
      }
      else
      {
         rseg[i] = get_num(third,num[i]);
         if (num[(i+1)%6] < 0)
            bseg[i] = -1;
         else
            bseg[i] = get_num(num[i],num[((i+1)%6)]);
      }
   }


   /*
        THIS IS WHERE SOME TESTS NEED TO BE MADE.
   */

}
