#include "cont_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: get_third.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

/***************************************************************************/
/*  Given two mesh points this routine returns a thrid point defining      */
/*  a triangle on the mesh which has not been searched when following a    */
/*  line of constant contour level.  The returned values follow the logic  */
/*  outlined below.  Given a mesh defined as:                              */
/*                                                                         */
/*                        Pd ... Ph ... Pl ... Pp                          */
/*                        .      .      .      .                           */
/*                        .      .      .      .                           */
/*                        Pc ... Pg ... Pk ... Po                          */
/*                        .      .      .      .                           */
/*                        .      .      .      .                           */
/*                        Pb ... Pf ... Pj ... Pn                          */
/*                        .      .      .      .                           */
/*                        .      .      .      .                           */
/*                        Pa ... Pe ... Pi ... Pm                          */
/*                                                                         */
/*  For points along the left edge and vertical: then if Pc and Pd         */
/*  are sent in Pg is returned                                             */
/*  For points along the right edge and vertical: then if Pn and Po        */
/*  are sent in Pj is returned                                             */
/*                                                                         */
/***************************************************************************/

ByTe_4 get_third (ByTe_4 P1, ByTe_4 P2, ByTe_4 Sb)
{
   extern struct cont_info cinfo;
   extern struct cont_alloc cal;

   register ByTe_4  Nc, Nr;
   register ByTe_1 *c1, *c2, *c3;

   ByTe_2 dP;
   ByTe_4 S1, S2, S3, T;
   ByTe_1 B;

   if (P1 > P2)                                   /* 1st index > 2nd?       */
   {                                              /* yes reverse them       */
      T = P1;                                     /* 1st index to tmp       */
      P1 = P2;                                    /* 2nd index to 1st       */
      P2 = T;                                     /* 1st index to 2nd       */
   }
   T = -2;                                        /* initialize return indx */

   Nr = cinfo.nr;                                 /* Fast # of rows         */
   Nc = cinfo.nc;                                 /* Fast # of cols         */
   c1 = cal.seg;                                  /* ptr to segment info    */
   c2 = cal.bad;                                  /* ptr to mesh quality    */

   dP = P2 - P1;                                  /* diff in mesh positions */

   if (dP == 1)                                   /* vertical segment?      */
   {                                              /* yes!                   */
      if (P2 < Nr)                                /* segment in 1st col?    */
         T = P1 + Nr + 1;                         /* yes - get 3rd pt       */
      else                                        /* no                     */
      {
         if (P1 > (Nr * (Nc - 1) - 1) )           /* segment in last col?   */
             T = P1 - Nr;                         /* yes - so get 3rd pt    */
         else                                     /* no!                    */
         {                                        /* segment is in mesh     */
            get_num (&S1, P1, P1 - Nr, &B);       /* left hor seg w/P1      */
            c1 = cal.seg + S1;                    /* seg info               */
            S2 = S1 + 1;                          /* left diag seg w/P1-Nr  */
            c3 = cal.seg + S2;                    /* seg info               */
            if (*c1 == 0 || *c3 == 0)             /* hor || diag unscanned? */
            {                                     /* yes                    */
               T = P1 - Nr;                       /* make this third        */
               if (*(c2 + T) == 1)                /* is data ok?            */
                  T = -1;                         /* no - cancel third      */
            }
            else
               S3 = (*c1 == 1) ? S1 : (*c3 == 1) ? S2 : -1;
         }
      }

      if (T < 0)                                  /* bad third point?       */
      {                                           /* unfortunately          */
         S1 += 3 * Nr - 1;                        /* right diag seg         */
         c1 = cal.seg + S1;                       /* right diag seg info   */
         S2 = S1 + 2;                             /* left diag seg w/P1-Nr  */
         c3 = cal.seg + S2;                       /* seg info               */
         if (*c1 == 0 || *c3 == 0)                /* hor || diag unscanned? */
         {                                        /* yes!                   */
            T = P1 + Nr + 1;                      /* make this 3rd point    */
            if (*(c2 + T) == 1)                   /* is data ok?            */
               T = -1;                            /* no - cancel third      */
         }
         else                                     /* scanned this triangle  */
         {
            if (S3 == Sb)                         /* back to beg on left?   */
               T = P1 - Nr;                       /* yes - ret this point   */
            else
            {
               S3 = (*c1 == 1) ? S1 : (*c3 == 1) ? S2 : -1;
               if (S3 == Sb)                      /* back to beg on right?  */
                 T = P2 + Nr;                     /* yes - ret this point   */
            }
         }
      }

      return (T);
   }

   if (dP == Nr)                                  /* horizontal segment?    */
   {                                              /* yes!                   */
      if (P1 % Nr == 0)                           /* segment on bot row?    */
         T = P1 + Nr + 1;                         /* yes - get 3rd pt       */
      else                                        /* no                     */
      {
         if (((P1 + 1) % Nr) == 0)                /* segment on top row ?   */
             T = P1 - 1;                          /* yes - so get 3rd pt    */
         else                                     /* no!                    */
         {                                        /* segment is in mesh     */
            get_num (&S1, P1, P1 - 1, &B);        /* down vertical seg w/P1 */
            c1 = cal.seg + S1;                    /* seg info               */
            S2 = S1 - 1;                          /* vert seg w/P1          */
            c3 = cal.seg + S2;                    /* seg info               */
            if (*c1 == 0 || *c3 == 0)             /* hor || diag unscanned? */
            {                                     /* yes                    */
               T = P1 - 1;                        /* make this third        */
               if (*(c2 + T) == 1)                /* is data ok?            */
                  T = -1;                         /* no - cancel third      */
            }
            else
               S3 = (*c1 == 1) ? S1 : (*c3 == 1) ? S2 : -1;
         }
      }

      if (T < 0)                                  /* bad third point?       */
      {                                           /* unfortunately          */
         S1 += 2;                                 /* up diag seg            */
         c1 = cal.seg + S1;                       /* up diag seg info       */
         S2 = S1 + 3 * Nr - 1;                    /* left diag seg w/P1-Nr  */
         c3 = cal.seg + S2;                       /* seg info               */
         if (*c1 == 0 || *c3 == 0)                /* hor || diag unscanned? */
         {                                        /* yes!                   */
            T = P1 + Nr + 1;                      /* make this 3rd point    */
            if (*(c2 + T) == 1)                   /* is data ok?            */
               T = -1;                            /* no - cancel third      */
         }
         else                                     /* scanned this triangle  */
         {
            if (S3 == Sb)                         /* back to beg on left?   */
               T = P1 - 1;                        /* yes - ret this point   */
            else
            {
               S3 = (*c1 == 1) ? S1 : (*c3 == 1) ? S2 : -1;
               if (S3 == Sb)                      /* back to beg on right?  */
                 T = P2 + 1;                      /* yes - ret this point   */
            }
         }
      }

      return (T);
   }
                                                  /* initial seg is diag    */
   get_num (&S1, P1, P1 + 1, &B);                 /* up vertical seg w/P1   */
   c1 = cal.seg + S1;                             /* seg info               */
   S2 = S1 + 1;                                   /* vert seg w/P1          */
   c3 = cal.seg + S2;                             /* seg info               */
   if (*c1 == 0 || *c3 == 0)                      /* ver || diag unscanned? */
   {                                              /* yes                    */
      T = P1 + 1;                                 /* make this third        */
      if (*(c2 + T) == 1)                         /* is data ok?            */
         T = -1;                                  /* no - cancel third      */
   }
   else
      S3 = (*c1 == 1) ? S1 : (*c3 == 1) ? S2 : -1;

   if (T < 0)                                     /* bad third point?       */
   {                                              /* unfortunately          */
      S1 -= 2;                                    /* up diag seg            */
      c1 = cal.seg + S1;                          /* up diag seg info       */
      S2 = S1 + 3 * Nr;                           /* left diag seg w/P1-Nr  */
      c3 = cal.seg + S2;                          /* seg info               */
      if (*c1 == 0 || *c3 == 0)                   /* hor || diag unscanned? */
      {                                           /* yes!                   */
         T = P1 + Nr;                             /* make this 3rd point    */
         if (*(c2 + T) == 1)                      /* is data ok?            */
            T = -1;                               /* no - cancel third      */
      }
      else                                        /* scanned this triangle  */
      {
         if (S3 == Sb)                            /* back to beg on left?   */
            T = P1 + 1;                           /* yes - ret this point   */
         else
         {
            S3 = (*c1 == 1) ? S1 : (*c3 == 1) ? S2 : -1;
            if (S3 == Sb)                         /* back to beg on right?  */
              T = P2 - 1;                         /* yes - ret this point   */
         }
      }
   }

   return(T);
}
