#include "gph_str.h"
#include "cont_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: get_cell.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

/****************************************************************************/
/*  This subroutine returns the coordinates of one subcell in a contour     */
/*  grid. The position of the subcell is given by bot, side.  The subcell   */
/*  with bot = 0 and side = 0 is in the lower lefthand corner of the grid.  */
/****************************************************************************/


void get_cell(ByTe_4 bot, ByTe_4 side, ReaL_4 *info, ReaL_4 *ce)
{
   register ReaL_4 *f1, *f2, *f3;

   /*************************************************************************/
   /* Find the x coordinates for the corners of this subcell moving counter */
   /* clockwise from the lower left-hand corner                             */
   /*************************************************************************/

   f1 = ce;                        /* pointer to returned corner positions */
   f2 = info;                      /* pointer in grid corner coordinates   */
   f3 = info + 2;                  /* pointer to subcell lengths           */

   *f1++ = *f2 + bot * *f3;        /* lower left-hand x corner coordinate  */
   *f1++ = *f2 + (bot + 1) * *f3;  /* lower right-hand x corner coordinate */
   *f1++ = *f2 + (bot + 1) * *f3;  /* upper right-hand x corner coordinate */
   *f1++ = *f2++ + bot * *f3++;    /* upper left-hand x corner coordinate  */

   /*************************************************************************/
   /* Find the y coordinates for the corners of this subcell moving counter */
   /* clockwise from the lower left-hand corner                             */
   /*************************************************************************/

   *f1++ = *f2 + side * *f3;       /* lower left-hand x corner coordinate  */
   *f1++ = *f2 + side * *f3;       /* lower right-hand x corner coordinate */
   *f1++ = *f2 + (side + 1) * *f3; /* upper right-hand x corner coordinate */
   *f1++ = *f2 + (side + 1) * *f3; /* upper left-hand x corner coordinate  */
}
