#include <math.h>
#include <string.h>
#include "gph_str.h"
#include "cont_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: gen_con.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

/*************************************************************
 *   This program is the fundamental routine for the making  *
 * of contour lines.   The program is called by mk_contour   *
 * and needs no parameters passed -- all variables exist in  *
 * the previously defined structures cinfo, cal, and cdisp.  *
 *   The levels of contouring begin at cinfo.begin and go up *
 * to cinfo.finish by increments of cinfo.stepsize creating  *
 * cinfo.numlevels contour levels.                           *
 *   The current level of contouring is stored in            *
 * cinfo.clevel.  The program then begins to loop through all*
 * the segment numbers as stored in cal.seg to test if the   *
 * clevel passes between the endpts of the segment as deter- *
 * mined by twixt.c.  If the segment number is 0 (meaning    *
 * the segment has not been tested at this level) then it is *
 * sent to twixt.  If it is between, bord() determines if the*
 * segment is on a border of the plot, on a border because   *
 * one of its endpts is no good, or in the middle of the plot*
 * The program will loop through anywhere between 0 & 2 based*
 * on the value returned by bord().                          *
 *   After it has been determined that the pt is between the *
 * z-values of the endpts, start is set to this segment #,   *
 * and the program makes its first call to recursive.  When  *
 * control is returned from recursive, the pts to be drawn   *
 * will be contained in the mr[] array of mv_n_drw.  If the  *
 * line numbering has been turned on for this level, the     *
 * numbers fill in the spaces created in the line by line_num*
 *    If the pt was NOT between the two endpts, the program  *
 * decides how it was not between.  If both the endpts were  *
 * below the clevel, the segment number is set to -1, other- *
 * wise it is set to a 1.  After all of the segments have    *
 * tested for this level, the seg array is decremented by 1. *
 * Therefore, before decrementing all the values will either *
 * be 1 or negative.  After decrementing, all the values are *
 * either 0 or less than -1.  From then on only values of 0  *
 * are tested since all negative values are segments below   *
 * the current level.                                        *
 *************************************************************/
 
void gen_con()
{
   extern struct config parm;
   extern struct cont_disp cdisp;
   extern struct cont_info cinfo;
   extern struct cont_alloc cal;

   register ByTe_1  *c1, *cend;
   register ReaL_4 *f1;
   ByTe_1  BT;
   ByTe_2 i, k;
   ByTe_2 C;
   ByTe_4 j, id1, id2, start;
   ReaL_4 Fc;
   ReaL_4 X,Y, ct;

   cdisp.times = 0;

   plt_color (0, cdisp.normal);
   f1 = cdisp.Xcol;

   for (ct=cinfo.begin, i=0; i < cinfo.numlevels; ++i, ct += cinfo.stepsize)
   {
      cinfo.clevel = ct;
      if (cdisp.output == 1)
      {
         Fc = *(f1+1) + *f1 * ct;
         if (Fc > *(f1+2))
            C = *(f1+2);
         else
            C = (Fc < *(f1+3)) ? 0 : Fc; 
         plt_color (0, C);
      }      

      c1 = cal.seg;
      cend = c1 + cinfo.numseg;
      for (j = 0; c1 < cend; ++j, ++c1)
      {
        if (*c1 == 0) 
        {
          for (k = 0; k < (2 - bord(j, &id1, &id2)); ++k)
          {
            BT = twixt(id1, id2);
            if (BT == 1 || BT == -1)
            {
               cinfo.line_stat = BT; 
               if (cdisp.lin_inc != 0)
                  cdisp.num_on = (i % cdisp.lin_inc == 0) ? 1 : 0;
               else 
                  cdisp.num_on = 0;

               *c1 = 1;
               start = j;
               interpol(id1, id2, &X, &Y);
               cinfo.calls = 0;
               mv_n_drw (cdisp.window, X, Y, 0., 0, 0);
               recursive(id1,id2,start);
               if (cinfo.line_stat == 1)
               {
                   cinfo.calls = 0;
                   mv_n_drw (cdisp.window, X, Y, 0., 0, 0);
                   recursive(id1,id2,start);
               }
            }
            else 
              if (BT < 3)
                  *c1 = (BT == 0) ? -1 : 1;
          }
          if (k==0)
             *c1 = 0;
        }
      }

      for (c1 = cal.seg; c1 < cend; ++c1)
      {
         if (*c1 != 0)
            --(*c1);
      }
   }

   DoLabels ();
   plt_color (0,parm.white);

}
