#include "cont_str.h"
#include "gph_ansi.h"
#define ABS(x) (((x) < 0) ? -(x) : (x))

static ByTe_1 rcsid[] = "$Id: close_plns.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

void close_plns (ReaL_4 *z, ReaL_4 zct, ByTe_4 close, ByTe_2 dt, ByTe_2 *begpl, 
                 ByTe_2 *endpl, ByTe_4 *cl1)
{
   extern struct three_d_cut cut;
   register ReaL_4 dif1,dif2;
   register ByTe_4 i,pt;
   register ByTe_2 pln,div;

   *cl1 = close;
   dif1 = *(z + *cl1) - zct;
   dif1 = ABS(dif1);
   for (i=dt ; i < dt+2 ; ++i)
   {
      pt = close + cut.npts_set*i;
      dif2 = *(z + pt) - zct;
      dif2 = ABS(dif2);
      if (dif2 < dif1)
      {
         dif1 = dif2;
         *cl1 = pt;
      }
   }

   pln = *cl1/cut.npts_set;
   div = cut.depth_nb/2;

   if (cut.depth_nb%2)
   {
      *begpl = pln - div;
      *endpl = pln + div;
   } 
   else
   {
      if (dt == 0)
      {
         *begpl = 0;
         *endpl = div;
      }
      else if (dt == cut.num_plns-2)
      {
         *begpl = cut.num_plns - 1 - div;
         *endpl = cut.num_plns - 1;
      }
      else
      {
         dif1 = zct - *(z + *cl1 - cut.npts_set);
         dif2 = zct - *(z + *cl1 + cut.npts_set); 
         if (ABS(dif1) < ABS(dif2))
         {
            *begpl = pln - div - 1;
            *endpl = pln + div - 1;
         }
         else
         {
            *begpl = pln - div + 1;
            *endpl = pln + div + 1;
         }
      }
   }
   if (*begpl < 0)
      *begpl = 0;
   if (*endpl > cut.num_plns - 1)
      *endpl = cut.num_plns - 1;
}
