#include "gph_str.h"
#include "gph_ansi.h"
#include "cont_defs.h"
#include "cont_str.h"
#include <stdlib.h>
#include <string.h>

static ByTe_1 rcsid[] = "$Id: SetUpMem.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

void SetUpMem ()
{
   extern struct config parm;
   extern struct cont_info cinfo;
   extern struct cont_disp cdisp;
   extern struct cont_alloc cal;
   ByTe_4 bytes, Nbors;
   ByTe_4 i, j, MatSize;
   ByTe_4 extra;
   ByTe_4 Clabs, N;
   ByTe_4 TrOr;

/**************************************************************************/
/*  From the users requested order get set up the necessary matrix fields */
/*  and make sure that there is the correct minimum number of neighbors   */
/*  requested. If not back off the order to match the number of requested */
/*  neighbors.                                                            */
/**************************************************************************/

   if (!cinfo.three_d)
   {
      N = 5;
      cinfo.rank = 1;
      for (j = 1; j <= cinfo.order; )
         cinfo.rank += j++ + 1;

      TrOr = 2 * cinfo.order;
      cinfo.XYrank = 1;
      for (j = 1; j <= TrOr; )
         cinfo.XYrank += j++ + 1;

      if (cinfo.data_type == 2 && cinfo.NFmt == 1 && cinfo.Norder == 0)
         cinfo.order = 0; 
   }
   else
   {
      N = 6;
      TrOr = 2 * cinfo.order;
      cinfo.rank = 1;
      cinfo.XYrank = 1;
      for (j = 1, i = 2; j <= TrOr; )
      {
         cinfo.rank = cinfo.XYrank;
         cinfo.XYrank += j++ + i;
         i += j;
      }

      if (cinfo.NFmt == 1 && cinfo.Norder == 0)
         cinfo.order = 0; 
   }

/**************************************************************************/
/*  Get the number of labeled contour levels and figure 4 labels per      */
/*  level.                                                                */
/**************************************************************************/

   Clabs = cinfo.numlevels / cdisp.lin_inc * 4;     /* # cont labs to save  */

/**************************************************************************/
/*  Now that we've settled all that do some more initialization on how    */
/*  the data is to be accumulated based on the number of neighbors to     */
/*  be used in the fit and the fit format to be used.                     */
/**************************************************************************/

   GatherParam ();                                  /* set up data gathering */
   Nbors = cinfo.Nbors;                             /* max neighbors to get  */

/**************************************************************************/
/*  Figure out how many bytes we need to malloc to hold all the info      */
/**************************************************************************/

   bytes = cinfo.gridsize * parm.SSize.Fsize;       /* countour grid         */
   extra = (cinfo.data_type == 0) ? 12 : 4;         /* neighbors + quad      */ 
   bytes += cinfo.nr * parm.SSize.Fsize;            /* one grid column       */
   bytes += cinfo.nc * parm.SSize.Fsize;            /* one grid row          */
   bytes += N * (Nbors + extra) * parm.SSize.Fsize; /* matrix neighbor stuff */
   bytes += cinfo.XYrank * parm.SSize.Dsize;        /* matrix elements       */ 
   bytes += cinfo.rank * parm.SSize.Dsize;          /* matrix intensity elem */ 
   MatSize = 2 * cinfo.rank * cinfo.rank;           /* elements in matrix    */
   bytes += MatSize * parm.SSize.Dsize;             /* matrix - use & bkup   */
   bytes += Nbors * parm.SSize.Lsize;               /* random near nb pos    */
   bytes += 4 * Clabs * parm.SSize.Lsize;           /* contour labeling      */
   bytes += cinfo.numseg;                           /* segment array         */
   bytes += cinfo.gridsize;                         /* bad data flag array   */
   bytes += cinfo.N;                                /* data quality flag     */
   bytes = bytes + 4;                               /* one word pad          */
   
   if (cal.totbytes < bytes)                        /* memory exists?        */
   {                                                /* no or yes w/few bytes */
      if (cal.totbytes > 0)                         /* malloc done?          */
         free(cal.initmem);                         /* yes - free that space */
      cal.totbytes = bytes;                         /* set bytes malloced    */
      if ((cal.initmem = malloc(bytes)) == 0)       /* malloc memory - ok?   */
      {
         printf("\n\nINIT_CONT - MALLOC1 ERROR\n"); /* error - print it      */
         exit (-1);                                 /* split                 */
      }
   }
   memset (cal.initmem, 0, cal.totbytes);            /* zero out memory      */

/**************************************************************************/
/*  Set up pointers                                                       */
/**************************************************************************/

   cal.Velem  = (ReaL_8 *) (cal.initmem);           /* val matrix elements   */
   cal.XYelem = cal.Velem + cinfo.rank;             /* x-y matrix elements   */
   cal.Mat    = cal.XYelem + cinfo.XYrank;          /* the basic matrix      */
   cal.z      = (ReaL_4 *) (cal.Mat + MatSize);     /* location id's         */
   cal.Mx     = cal.z + cinfo.gridsize;             /* x pos's for least sq  */
   cal.My     = cal.Mx + (Nbors + extra);           /* y pos's for least sq  */
   if (cinfo.three_d)                               /* 3D data?              */
   {                                                /* Yes                   */
      cal.Mz     = cal.My + (Nbors + extra);        /* y pos's for least sq  */
      cal.Mv     = cal.Mz + (Nbors + extra);        /* values for least sq   */
   }
   else
      cal.Mv     = cal.My + (Nbors + extra);        /* values for least sq   */
   cal.weight = cal.Mv + (Nbors + extra);           /* weighting factors     */

   cal.d      = cal.weight + (Nbors + extra);       /* distances             */
   cal.X      = cal.d + (Nbors + extra);            /* X grid positions      */
   cal.Y      = cal.X + cinfo.nc;                   /* Y grid positions      */
   cal.id     = (ByTe_4 *) (cal.Y + cinfo.nr);      /* location id's         */
   cal.sX     = (ReaL_4 *)(cal.id + Nbors);         /* label x positions     */
   cal.sY     = cal.sX + Clabs;                     /* label y positions     */
   cal.sA     = cal.sY + Clabs;                     /* label angles          */
   cal.sL     = cal.sA + Clabs;                     /* label levels          */
   cal.seg    = (ByTe_1 *) (cal.sL + Clabs);        /* segment info array    */
   cal.bad   = cal.seg + cinfo.numseg;              /* bad data info array   */
   cal.dQ    = cal.bad + cinfo.gridsize;            /* data qual info array  */

/**************************************************************************/
/*  If we are using the same data xy values in other contours (different) */
/*  intensity values - then malloc memory to save stuff we would have to  */
/*  re-compute at each contour                                            */ 
/**************************************************************************/

   if (cinfo.same == 1)                             /* same xy data?        */
   {                                                /* yes?                 */
      bytes = (cinfo.gridsize + 1) * parm.SSize.Lsize; /* this many bytes   */
      if (cal.totsave < bytes)                      /* got enough mem?      */
      {                                             /* no!                  */
         cal.totsave = bytes;                       /* memory size          */
         if (cal.remem != NULL)                     /* already got memory?  */
            free(cal.remem);                        /* yes - free it        */
         if ((cal.remem = malloc(bytes)) == 0)      /* malloc them - ok?    */
         {                                          /* no -got error        */
            printf("\nSetUpMem - MALLOC2 ERROR\n"); /* error - print it     */
            exit (-1);                              /* split                */
         }
         cal.save = (ByTe_4 *) cal.remem;           /* pointer to memory    */
      }
   }
}
