#include "gph_str.h"
#include "gph_ansi.h"
#include "cont_str.h"
#define SN(a) (((a) <= 0) ? (0) : (1))

static ByTe_1 rcsid[] = "$Id: Random3D.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

void Random3D (ReaL_4 *v, ReaL_4 *x, ReaL_4 *y, ReaL_4 *z)
{
   extern struct cont_info cinfo;
   extern struct cont_alloc cal;

   register ReaL_4 *f1, *f2, *f3, *f4, *f5, *f6;
   register ByTe_4  *l1, *l2;

   ReaL_4 *fend;
   ReaL_4 *gV;
   ReaL_4 *X, *Y, *Xend, *Yend, qD[12], Xr, Yr, Zr;
   ReaL_4 TmpD, MinD, CLen;
   ByTe_4 *lend;
   ByTe_4 Ln;
   ByTe_4 xI, yI, zI, rI, iD, Gp, MinId;
   ByTe_4 N, TmpI, Nb;
   ByTe_4 qL[12];

   ByTe_2 Qt;
   ByTe_1 New;
   ByTe_1 *bV;

   gV = cal.z;                                  /* ptr to grid values       */
   bV = cal.bad;                                /* ptr to bad grid values   */
   Ln = cinfo.Nbors - 1;                        /* last # of neighbors indx */

   CLen =  (cinfo.ystep < cinfo.xstep) ? cinfo.ystep : cinfo.xstep;

/****************************************************************************/
/*  Loop through all the data and assemble the requested number of nearest  */
/*  neighbors to the contour mesh position being solved for.  At the same   */
/*  time keep a set of nearest neighbors in each of the 8 quadrants about   */
/*  the mesh point.  This is added to nearest neighbors in end if not       */
/*  already included.  This should be an option but is not at present. It   */
/*  ensures that contributions if available from all sides are included in  */
/*  the fit.                                                                */
/****************************************************************************/
   
   Gp = 0;                                      /* zero Grid                */
   X = cal.X;                                   /* minimum X mesh value     */
   Xend = X + cinfo.nc;                         /* last X grid point        */
   Yend = cal.Y + cinfo.nr;                     /* last Y grid point        */
   for ( ; X < Xend; ++X)                       /* loop over mesh columns   */
   {                                            /* BEG MESH COLUMN LOOP     */
      Y = cal.Y;                                /* minimum X mesh value     */
      for ( ; Y < Yend; ++Y)                    /* loop over mesh columns   */
      {                                         /* BEGIN MESH ROW LOOP      */
         Qt = MeshEdge (Gp++);                  /* determine if mesh edge   */
         lend = qL + 12;                        /* end of quad index array  */
         for (l1 = qL; l1 < lend; )             /* loop over quad indices   */
             *l1++ = -1;                        /* quad index to empty      */

         fend = cal.d + cinfo.Nbors;            /* end of near neigbors dis */
         for (f1 = cal.d; f1 < fend; )          /* loop over near neigh dis */
             *f1++ = 1.0e30;                    /* distance to max          */

         f1 = x;                                /* data x positions         */
         f2 = y;                                /* data y positions         */
         f3 = z;                                /* data y positions         */
         fend = f1 + cinfo.N;                   /* end of data positions    */
         Nb = 0;                                /* good points found        */
         for (iD = 0; f1 < fend; ++iD)          /* loop over data           */
         {
            Xr = *f1++ - *X;                    /* relative x position      */
            Yr = *f2++ - *Y;                    /* relative y position      */
            Zr = *f3++;                         /* relative z position      */
            MinD = Xr * Xr + Yr * Yr + Zr * Zr; /* relative dis to mesh pt  */
            if (MinD > cinfo.MinR)              /* distance acceptable?     */
               continue;                        /* no - go to next point    */

            xI = (Xr < 0.0) ? 0 : 1;            /* x quadrant id            */
            yI = (Yr < 0.0) ? 0 : 2;            /* y quadrant id            */
            zI = (Zr == 0.) ? 4 : (Zr < 0.) ? 0 : 8;  /* z quadrant id      */
            rI = xI + yI + zI;                  /* quadrant data is in      */

            FillQuad (qD, qL, iD, rI, MinD, CLen);

            if (MinD < *(cal.d + Ln))           /* dis is 1 of smallest?    */
            {                                   /* yes!                     */
               ++Nb;                            /* inc possible points      */
               *(cal.d + Ln) = MinD;            /* put in last cal pos      */
               *(cal.id + Ln) = iD;             /* position of this dis     */
               f4 = cal.d;                      /* saved distances          */
               l1 = cal.id;                     /* saved data positions     */
               lend = l1 + Ln;                  /* end of saved distances   */ 
               for ( ; l1 < lend; ++f4, ++l1)   /* loop over saved dist's   */
               {
                  if ( *f4  > *(cal.d + Ln))    /* this greater than last?  */
                  {                             /* yes - swap them          */
                     TmpD = *f4;                /* current dis to temp      */
                     *f4 = *(cal.d + Ln);       /* last to current          */
                     *(cal.d + Ln) = TmpD;      /* current to last          */
                     TmpI = *l1;                /* current pos to temp      */
                     *l1 = *(cal.id + Ln);      /* last to current          */
                     *(cal.id + Ln) = TmpI;     /* current to last          */
                  }
               }
            }
         }

         if (Quad3DChk (qL) < Qt)               /* mesh point in data?     */
         {                                      /* no!                     */
            *bV++ = 1;                          /* grid point is bad       */
            ++gV;                               /* skip grid value         */
            continue;                           /* no - go to next         */
         }

         if (Nb >= cinfo.Nbors)                 /* find enough neighbors   */
            Nb = cinfo.Nbors;                   /* yes - reset it          */

         f1 = cal.d;                            /* ptr to closest dis      */
         f2 = cal.Mx;                           /* ptr to relative X pos   */
         f3 = cal.My;                           /* ptr to relative Y pos   */
         f4 = cal.Mz;                           /* ptr to relative Z pos   */
         f5 = cal.Mv;                           /* ptr to data value       */
         l1 = cal.id;                           /* data location           */
         fend = cal.d + Nb;                     /* end of distance array   */
         MinD = *f1;                            /* first distance          */
         MinId = *l1;                           /* location of minimum dis */
         Nb = 0;                                /* nearest neighbors to 0  */
         for ( ; f1 < fend; ++f1)               /* loop over distances     */
         {
             if (*f1 < MinD)                    /* this dis less than min? */
             {                                  /* yes                     */
                MinD = *f1;                     /* replace min distanc     */
                MinId = *l1;                    /* replace location on min */
             }
             if (cal.dQ[*l1] > 0)               /* this data ok?           */
             {
                ++Nb;                           /* good nearest neighbor   */
                *f2++ = x[*l1] - *X;            /* relative X position     */
                *f3++ = y[*l1] - *Y;            /* relative Y position     */
                *f4++ = z[*l1];                 /* relative Z position     */
                *f5++ = v[*l1++];               /* data value              */
             }
         }

         if (Nb < cinfo.rank)                   /* make unique solution?   */
         {                                      /* no                      */
            *bV++ = 1;                          /* mesh pt to bad          */
            *gV++ = 0.0;                        /* dummy grid value        */
            continue;                           /* on to next mesh value   */
         }

         N = Nb;
         f1 = cal.d + N;                        /* ptr to next dis         */
         f2 = cal.Mx + N;                       /* ptr to next rel X pos   */
         f3 = cal.My + N;                       /* ptr to next rel Y pos   */
         f6 = cal.Mz + N;                       /* ptr to next rel Z pos   */
         f4 = cal.Mv + N;                       /* ptr to next data value  */
         f5 = qD;                               /* quadrant distances      */
         l2 = qL;                               /* quadrant locations      */

         lend = cal.id + N;                     /* last data location pos  */
         fend = f5 + 12;                        /* end of quad distances   */
         for ( ; f5 < fend; ++l2, ++f5)         /* loop over quad data     */
         {
             if (*l2 >= 0)                      /* got pos for this quad?  */
             {                                  /* yes                     */
                New = 0;                        /* set to no match         */
                l1 = cal.id;                    /* data location           */
                while (!New && l1 < lend)       /* loop over found pos     */
                {
                    if (*l1++ == *l2)           /* position match?         */
                       New = 1;                 /* set to match            */
                }

                if (!New && cal.dQ[*l2] > 0)    /* no match?               */
                {                               /* nope!                   */
                   *f1++ = *f5;                 /* add distance            */
                   *f2++ = x[*l2] - *X;         /* add relative X pos      */
                   *f3++ = y[*l2] - *Y;         /* add relative Y pos      */
                   *f6++ = z[*l2];              /* add relative Z pos      */
                   *f4++ = v[*l2];              /* add value               */
                   ++N;                         /* one more neighbor       */
                }
             }
         }

         *bV = 0;                               /* mesh pt ok              */
         if (MinD <= 0.0)                       /* got perfect match?      */
         {                                      /* exact                   */
            *gV++ = v[MinId];                   /* set grid value to it    */
            if (cal.dQ[MinId] == 0)             /* is the data ok?         */
               *bV++ = 1;                       /* no - so mesh pt to bad  */
         }
         else
         {
            f1 = cal.weight;                    /* ptr to data weighting   */
            f2 = cal.d;                         /* ptr to data distances   */
            fend = f2 + N;                      /* end of data array       */
            for ( ; f2 < fend; )                /* loop over data          */
              *f1++ = get_wgt(MinD / *f2++);    /* form weighting          */

            *gV++ = Grid3DValue(N, bV++);       /* form grid value         */
         }
         
      }
   }
}
