#include "gph_str.h"
#include "gph_ansi.h"
#include "cont_str.h"

static ByTe_1 rcsid[] = "$Id: Random2DAll.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

void Random2DAll (ReaL_4 *v, ReaL_4 *x, ReaL_4 *y)
{
   extern struct cont_info cinfo;
   extern struct cont_alloc cal;

   register ReaL_4 *f1, *f2, *f3, *f4, *f5, *fend;
   register ByTe_4  *l1, *lend;

   ReaL_4 *gV, *f6, *f7;
   ReaL_4 *X, *Y, *Xend, *Yend, Xr, Yr;
   ReaL_4 MinD, D, CLen;
   ByTe_4  xI, yI, rI;
   ByTe_4  N;
   ByTe_4  qL[4];

   ByTe_2  Q;
   ByTe_1  *bV, *c1;

   gV = cal.z;                                  /* ptr to grid values       */
   bV = cal.bad;                                /* ptr to bad grid values   */

   CLen =  (cinfo.ystep < cinfo.xstep) ? cinfo.ystep : cinfo.xstep;

/****************************************************************************/
/*  Loop through all the data and assemble the requested number of nearest  */
/*  neighbors to the contour mesh position being solved for.  At the same   */
/*  time keep a set of nearest neighbors in each of the 4 quadrants about   */
/*  the mesh point.  This is added to nearest neighbors in end if not       */
/*  already included.  This should be an option but is not at present. It   */
/*  ensures that contributions if available from all sides are included in  */
/*  the fit.                                                                */
/****************************************************************************/

   X = cal.X;                                   /* minimum X mesh value     */
   Xend = X + cinfo.nc;                         /* last X grid point        */
   Yend = cal.Y + cinfo.nr;                     /* last Y grid point        */
   for ( ; X < Xend; ++X)                       /* loop over mesh columns   */
   {                                            /* BEG MESH COLUMN LOOP     */
      Y = cal.Y;                                /* minimum X mesh value     */
      for ( ; Y < Yend; ++Y)                    /* loop over mesh columns   */
      {                                         /* BEGIN MESH ROW LOOP      */
         if (*bV == 2)
         {
            *bV++ = 0;
            ++gV;
            continue;
         }

         lend = qL + 4;                         /* end of quad array        */
         for (l1 = qL; l1 < lend; )             /* loop over quad array     */
             *l1++ = 0;                         /* pnt this quad to no      */

         MinD = 1.0e30;                         /* max out min distance     */
         N = 0;                                 /* legal points             */

         f1 = x;                                /* data x positions         */
         f2 = y;                                /* data y positions         */
         f3 = y;                                /* data y positions         */
         f4 = cal.Mx;                           /* relative data x pos      */
         f5 = cal.My;                           /* relative data y pos      */
         f6 = cal.Mv;                           /* data value               */
         f7 = cal.d;                            /* relative data distance   */
         c1 = cal.dQ;                           /* ptr to data quality      */
         fend = f1 + cinfo.N;                   /* end of data positions    */
         for ( ; f1 < fend; ++f3)               /* loop over data           */
         {
            Xr = *f1++ - *X;                    /* relative x position      */
            Yr = *f2++ - *Y;                    /* relative y position      */
            D = Xr * Xr + Yr * Yr;              /* relative dis to mesh pt  */
            if (D > cinfo.MinR)                 /* distance acceptable?     */
               continue;                        /* no - go to next point    */

            if (D < MinD)                       /* minumum distance?        */
               MinD = D;                        /* save it                  */

            if (*c1++ > 0)                      /* this data was good?      */
            {                                   /* yes it was               */
               ++N;                             /* this many data points    */
               *f4++ = Xr;                      /* relative X position      */
               *f5++ = Yr;                      /* relative Y position      */
               *f6++ = *f3;                     /* data value               */
               *f7++ = D;                       /* distance to mesh         */

               xI = (Xr >= 0.0) ? 0 : 1;        /* x quadrant id            */
               yI = (Yr >= 0.0) ? 0 : 2;        /* y quadrant id            */
               rI = xI + yI;                    /* quadrant data is in      */

               qL[rI] = 1;                      /* point in this quad       */
            }
         }
     
         l1 = qL;                               /* ptr to quad info        */
         lend = qL + 4;                         /* end of quad info        */
         for (Q = 0 ; l1 < lend; )              /* loop over quad info     */
            Q += *l1++;                         /* sum quad info values    */

         if (Q != 4)                            /* mesh point in data?     */
         {                                      /* no!                     */
            *bV++ = 1;                          /* grid point is bad       */
            ++gV;                               /* skip grid value         */
            continue;                           /* no - go to next         */
         }

         f1 = cal.weight;                       /* ptr to data weighting   */
         f2 = cal.d;                            /* ptr to data distances   */
         fend = f2 + N;                         /* end of data array       */
         for ( ; f2 < fend; )                   /* loop over data          */
           *f1++ = get_wgt(MinD / *f2++);       /* form weighting          */

         *bV = 0;                               /* mesh pt ok              */
         *gV++ = Grid2DValue(N, bV++);          /* form grid value         */
          
      }
   }
}
