#include "cont_str.h"
#include "gph_ansi.h"

/*****************************************************************************/
/*  This routine finds the 8 data points surrounding the data point which    */
/*  is located at the location C.  The location of these points in the data  */
/*  array are returned in the array Q.  The definitions are:                 */
/*                                                                           */
/*                     Q[3] ... Q[2] ... Q[1]                                */
/*                      .        .        .                                  */
/*                      .    1   .    0   .                                  */
/*                      .        .        .                                  */
/*                     Q[4] .... C  .... Q[0]                                */
/*                      .        .        .                                  */
/*                      .    2   .    3   .                                  */
/*                      .        .        .                                  */
/*                     Q[5] ... Q[6] ... Q[7]                                */
/*                                                                           */
/*  The routine returns a status byte S which indicates the position of the  */
/*  center point within the data mesh.  The values are                       */
/*                                                                           */
/*       0 - center point interior to mesh                                   */
/*       1 - center point on right-hand edge - not corner point              */
/*       2 - center point is upper right-hand corner point                   */
/*       3 - center point on upper edge - not corner point                   */
/*       4 - center point is upper left-hand corner point                    */
/*       5 - center point on left-hand edge - not corner point               */
/*       6 - center point is lower left-hand corner point                    */
/*       7 - center point on lower edge - not corner point                   */
/*       8 - center point is lower right-hand corner point                   */
/*                                                                           */
/*  Locations 8-11 in the Q array hold the smallest data location position   */
/*  for cells 0 thru 3 respectively                                          */
/*****************************************************************************/

static ByTe_1 rcsid[] = "$Id: QuadPntsNcyc.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

ByTe_1 QuadPntsNcyc (ByTe_4 C, ByTe_4 *Q)
{
   extern struct cont_info cinfo;
   register ByTe_4 *l1, *l2;
   register ByTe_4 L;
   register ByTe_4 R;

   ByTe_1 top_ok, bot_ok;
   ByTe_1 r_side_ok, l_side_ok;
   ByTe_1 S;

   R = C / cinfo.Y + 1;                         /* next column of data       */
   r_side_ok = (R == cinfo.X) ? 0 : 1;          /* 1 more data col to right? */
   l_side_ok = (C < cinfo.Y) ? 0 : 1;           /* 1 more data col to left?  */
   R = C + 1;                                   /* one data point up         */
   top_ok = ((R % cinfo.Y) == 0) ? 0 : 1;       /* 1 more data row up?       */
   bot_ok = ((C % cinfo.Y) == 0) ? 0 : 1;       /* 1 more data row down?     */

   R = C + cinfo.Y;                             /* data to right of center   */
   L = C - cinfo.Y;                             /* data to left of center    */
   l1 = Q;                                      /* pntr to output array      */

   *l1++ = (r_side_ok) ? R : -1;                /* loc of right horiz pnt    */ 
   *l1++ = (r_side_ok && top_ok) ? R + 1 : -1;  /* loc of right up diag pnt  */
   *l1++ = (top_ok) ? C + 1 : -1;               /* loc of upper vert pnt     */
   *l1++ = (l_side_ok && top_ok) ? L + 1 : -1;  /* loc of left up diag pnt   */
   *l1++ = (l_side_ok) ? L : -1;                /* loc of left horiz pnt     */
   *l1++ = (l_side_ok && bot_ok) ? L - 1 : -1;  /* loc of left dwn diag pnt  */
   *l1++ = (bot_ok) ? C - 1 : -1;               /* loc of dwn vert point     */
   *l1++ = (r_side_ok && bot_ok) ? R - 1 : -1;  /* loc of right dwn diag pnt */

   if (!r_side_ok)
      S = (!top_ok) ? 2 : (!bot_ok) ? 8 : 1;
   else
   {
      if (!l_side_ok)
         S = (!top_ok) ? 4 : (!bot_ok) ? 6 : 5;
      else
         S = (!top_ok) ? 3 : (!bot_ok) ? 7 : 0;
   }

   *l1++ = C;                                  /* min data loc of cell 0    */
   l2 = Q + 4;                                 /* pointer to min location   */
   *l1++ = *l2++;                              /* min data loc of cell 1    */
   *l1++ = *l2++;                              /* min data loc of cell 2    */
   *l1 = *l2;                                  /* min data loc of cell 3    */

   return (S);
}
