#include <math.h>
#include "cont_str.h"
#include "gph_ansi.h"
#define DIF(a,b) (((a)<(b)) ? ((b)-(a)) : ((a)-(b)))

static ByTe_1 rcsid[] = "$Id: OrderedNcyc.c,v 1.1 1999/11/21 08:39:31 chris.gurgiolo.b2r Stab chrisg $";

void OrderedNcyc (ReaL_4 *v, ReaL_4 *x, ReaL_4 *y, ReaL_4 *z)
{
   extern struct cont_info cinfo;
   extern struct cont_alloc cal;
   register ReaL_4 *X, *Y, *Xend, *Yend;
   register ReaL_4 *f1;
   register ByTe_4  *l1;
   ReaL_8 max;
   ReaL_4 Xm, Ym, Zm = 0;
   ByTe_4  Nbor, close, N;
   ByTe_1  *c1;

   max = cinfo.xstep * cinfo.xstep + cinfo.ystep * cinfo.ystep;

   l1  = cal.save;
   c1  = cal.bad;
   f1  = cal.z;

   N = cinfo.N;

   if (!cinfo.second || !cinfo.same) {
      X = cal.X;                                /* minimum X mesh value     */
      Xend = X + cinfo.nc;                      /* last X grid point        */
      Yend = cal.Y + cinfo.nr;                  /* last Y grid point        */
      for ( ; X < Xend; ++X) {                  /* BEG MESH COLUMN LOOP     */
         Y = cal.Y;                             /* minimum X mesh value     */
         for ( ; Y < Yend; ++Y) {               /* BEGIN MESH ROW LOOP      */
            Xm = *X;
            Ym = *Y;

            if ((close = find_close (x, y, max, N, Xm, Ym)) < 0) {
               *c1++ = 0;
               if (cinfo.same)
                  *l1++ = -close + 1;
               *f1++ = *(v - close + 1);
            } else {
               if (cinfo.order == 0) {
                  *c1++ = 0;
                  if (cinfo.same)
                     *l1++ = close;
                  *f1++ = *(v + close);
               } else {
                  Nbor = GatherNcyc (v, x, y, z, Xm, Ym, Zm, close);
                  if (Nbor < cinfo.rank) {
                     *c1++ = 1;
                     if (cinfo.same)
                        *l1++ = -1;
                     *f1++ = *(v + close);
                  } else {
                     if (cinfo.same)
                        *l1++ = close;

                     *c1 = 0;
                     *f1++ = Grid2DValue(Nbor, c1++);
                  }
               }
            }
         }
      }
   } else {
      X = cal.X;                                /* minimum X mesh value     */
      Xend = X + cinfo.nc;                      /* last X grid point        */
      Yend = cal.Y + cinfo.nr;                  /* last Y grid point        */
      for ( ; X < Xend; ++X) {                  /* BEG MESH COLUMN LOOP     */
         Y = cal.Y;                             /* minimum X mesh value     */
         for ( ; Y < Yend; ++Y) {               /* BEGIN MESH ROW LOOP      */
            if (*c1++) {
               *f1++ = 0.0;
               ++l1;
            } else {
               Xm = *X;
               Ym = *Y;

               if (cinfo.order == 0)
                  *f1++ = *(v + *l1++);
               else {
                  Nbor = GatherNcyc (v, x, y, z, Xm, Ym, Zm, *l1++);

                  *c1 = 0;
                  *f1++ = Grid2DValue(Nbor, c1++);
               }
            }
         }
      }
   }
}
